/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.synchronization;

import java.util.List;

public class ServerSyncConfig {
    private final List<String> servers;
    private final boolean matchesAll;
    private final boolean disabled;

    public ServerSyncConfig(List<String> servers) {
        this.servers = servers;
        this.disabled = servers.size() <= 1;
        this.matchesAll = servers.contains("[ALL]");
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public List<String> getServers() {
        return this.servers;
    }

    public boolean isMatchesAll() {
        return this.matchesAll;
    }

    public boolean matchesServer(String serverName) {
        return this.matchesAll || this.servers.contains(serverName);
    }
}

