/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.warnings.gui;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlinePlayerSession;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.actions.ActionService;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.WarnService;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.Warning;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.WarningConfiguration;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.WarningSeverityConfiguration;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class WarningsGuiController {
    private static final String CANCEL = "cancel";
    private static final String NONE = "none";
    private static final int PAGE_SIZE = 45;
    private final PlayerManager playerManager;
    private final WarnService warnService;
    private final OnlineSessionsManager sessionManager;
    private final WarningConfiguration warningConfiguration;
    private final Messages messages;
    private final BukkitUtils bukkitUtils;
    private final ActionService actionService;

    public WarningsGuiController(PlayerManager playerManager, WarnService warnService, OnlineSessionsManager sessionManager, WarningConfiguration warningConfiguration, Messages messages, BukkitUtils bukkitUtils, ActionService actionService) {
        this.playerManager = playerManager;
        this.warnService = warnService;
        this.sessionManager = sessionManager;
        this.warningConfiguration = warningConfiguration;
        this.messages = messages;
        this.bukkitUtils = bukkitUtils;
        this.actionService = actionService;
    }

    @GuiAction(value="manage-warnings/view/overview")
    public AsyncGui<GuiTemplate> warningsOverview(@GuiParam(value="targetPlayerName") String targetPlayerName, @GuiParam(value="page", defaultValue="0") int page) {
        SppPlayer target = null;
        if (StringUtils.isNotBlank(targetPlayerName)) {
            target = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        }
        SppPlayer finalTarget = target;
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("warnings", this.getWarnings(finalTarget, page));
            return GuiTemplate.template("gui/warnings/warnings-overview.ftl", params);
        });
    }

    private List<Warning> getWarnings(SppPlayer target, int page) {
        if (target == null) {
            return this.warnService.getAllWarnings(page * 45, 45, true);
        }
        return this.warnService.getWarnings(target.getId(), page * 45, 45, true);
    }

    @GuiAction(value="manage-warnings/view/my-warnings")
    public AsyncGui<GuiTemplate> myWarningsOverview(Player player, @GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            List<Warning> warnings = this.warnService.getWarnings(player.getUniqueId(), page * 45, 45, false);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("warnings", warnings);
            return GuiTemplate.template("gui/warnings/my-warnings-overview.ftl", params);
        });
    }

    @GuiAction(value="manage-warnings/view/select-severity")
    public GuiTemplate selectSeverity(@GuiParam(value="targetPlayerName") String targetPlayerName) {
        SppPlayer target = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("target", target);
        params.put("severityLevels", this.warningConfiguration.getSeverityLevels());
        return GuiTemplate.template("gui/warnings/severity-selection.ftl", params);
    }

    @GuiAction(value="manage-warnings/view/detail")
    public AsyncGui<GuiTemplate> warningDetail(@GuiParam(value="warningId") int warningId) {
        return AsyncGui.async(() -> {
            Warning warning = this.warnService.getWarning(warningId);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("warning", warning);
            params.put("rollbackCommands", this.actionService.getActions(warning).stream().filter(s -> s.isExecuted() && s.isRollbackable() && !s.isRollbacked()).map(s -> s.getRollbackCommand().get().getCommand()).collect(Collectors.toList()));
            return GuiTemplate.template("gui/warnings/warning-detail.ftl", params);
        });
    }

    @GuiAction(value="manage-warnings/delete")
    public void deleteWarning(Player player, @GuiParam(value="warningId") int warningId) {
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.warnService.removeWarning(warningId));
    }

    @GuiAction(value="manage-warnings/expire")
    public void expireWarning(Player player, @GuiParam(value="warningId") int warningId) {
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.warnService.expireWarning(warningId));
    }

    @GuiAction(value="manage-warnings/warn")
    public void warnPlayer(Player player, @GuiParam(value="severity") String severityLevel, @GuiParam(value="targetPlayerName") String targetPlayerName) {
        PlayerSession playerSession = this.sessionManager.get(player);
        WarningSeverityConfiguration severityConfiguration = this.warningConfiguration.getSeverityConfiguration(severityLevel).orElseThrow(() -> new BusinessException("&CNo severity configuration found for level [" + severityLevel + "]"));
        SppPlayer onOrOfflinePlayer = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        if (!severityConfiguration.isReasonSettable()) {
            this.warnService.sendWarning((CommandSender)player, onOrOfflinePlayer, null, severityConfiguration);
        } else {
            this.promptReasonInput(player, playerSession, onOrOfflinePlayer, severityConfiguration);
        }
    }

    private void promptReasonInput(Player player, OnlinePlayerSession playerSession, SppPlayer onOrOfflinePlayer, WarningSeverityConfiguration severityConfiguration) {
        boolean defaultReasonSettable = severityConfiguration.getReason().isPresent() && severityConfiguration.isReasonOverwriteEnabled();
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6         You have chosen to warn this player", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6Type your reason for warning this player in chat", this.messages.prefixGeneral);
        if (defaultReasonSettable) {
            this.messages.send((CommandSender)player, "&6Type \"none\" to use the default reason", this.messages.prefixGeneral);
        }
        this.messages.send((CommandSender)player, "&6        Type \"cancel\" to cancel the warning ", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        playerSession.setChatAction((player1, input) -> {
            if (input.equalsIgnoreCase(CANCEL)) {
                this.messages.send((CommandSender)player, "&CYou have cancelled warning this player", this.messages.prefixWarnings);
                return;
            }
            if (input.equalsIgnoreCase(NONE) && defaultReasonSettable) {
                input = null;
            }
            this.warnService.sendWarning((CommandSender)player1, onOrOfflinePlayer, input, severityConfiguration);
            this.messages.send((CommandSender)player1, this.messages.inputAccepted, this.messages.prefixGeneral);
        });
    }
}

