/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.warnings.gui;

import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.WarningConfiguration;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.gui.WarnMessageStringUtil;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.warnings.IWarning;
import net.shortninja.staffplusplus.warnings.WarningCreatedEvent;
import net.shortninja.staffplusplus.warnings.WarningExpiredEvent;
import net.shortninja.staffplusplus.warnings.WarningRemovedEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class WarningChatNotifier
implements Listener {
    private final Messages messages;
    private final PlayerManager playerManager;
    private final WarningConfiguration warningConfiguration;

    public WarningChatNotifier(Messages messages, PlayerManager playerManager, WarningConfiguration warningConfiguration) {
        this.messages = messages;
        this.playerManager = playerManager;
        this.warningConfiguration = warningConfiguration;
    }

    @EventHandler
    public void notifyWarningIssued(WarningCreatedEvent event) {
        IWarning warning = event.getWarning();
        Optional<SppPlayer> issuer = this.playerManager.getOnlinePlayer(warning.getIssuerUuid());
        issuer.ifPresent(p -> this.messages.send((CommandSender)p.getPlayer(), WarnMessageStringUtil.replaceWarningPlaceholders(this.messages.warned, warning), this.messages.prefixWarnings));
        this.playerManager.getOnOrOfflinePlayer(warning.getTargetUuid()).filter(SppPlayer::isOnline).ifPresent(p -> {
            Player player = p.getPlayer();
            this.messages.send((CommandSender)player, WarnMessageStringUtil.replaceWarningPlaceholders(this.messages.warn, warning), this.messages.prefixWarnings);
            this.warningConfiguration.getSound().ifPresent(s -> s.play(player));
        });
        this.messages.sendGroupMessage(WarnMessageStringUtil.replaceWarningPlaceholders(this.messages.warnedAnnouncement, warning), this.warningConfiguration.getNotificationsPermission(), this.messages.prefixWarnings);
    }

    @EventHandler
    public void notifyWarningRemoved(WarningRemovedEvent event) {
        IWarning warning = event.getWarning();
        this.playerManager.getOnlinePlayer(warning.getIssuerUuid()).ifPresent(p -> this.messages.send((CommandSender)p.getPlayer(), "&2Warning has been removed", this.messages.prefixWarnings));
    }

    @EventHandler
    public void notifyWarningExpired(WarningExpiredEvent event) {
        IWarning warning = event.getWarning();
        this.playerManager.getOnlinePlayer(warning.getIssuerUuid()).ifPresent(p -> this.messages.send((CommandSender)p.getPlayer(), "&2Warning has been expired", this.messages.prefixWarnings));
    }
}

