/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.warnings.gui;

import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.model.TubingGui;
import net.shortninja.staffplus.core.common.gui.PagedGuiBuilder;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.staff.warn.appeals.WarningAppealConfiguration;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.WarnService;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.Warning;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.gui.WarningItemBuilder;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@IocBean
public class MyWarningsViewBuilder {
    private static final int PAGE_SIZE = 45;
    private final PermissionHandler permission;
    private final WarnService warnService;
    private final WarningItemBuilder warningItemBuilder;
    private final WarningAppealConfiguration warningAppealConfiguration;

    public MyWarningsViewBuilder(PermissionHandler permission, WarnService warnService, WarningItemBuilder warningItemBuilder, WarningAppealConfiguration warningAppealConfiguration) {
        this.permission = permission;
        this.warnService = warnService;
        this.warningItemBuilder = warningItemBuilder;
        this.warningAppealConfiguration = warningAppealConfiguration;
    }

    public TubingGui buildGui(Player player, String currentAction, int page) {
        return new PagedGuiBuilder.Builder("My warnings").addPagedItems(currentAction, this.getItems(player, page * 45, 45), this.warningItemBuilder::build, w -> this.getDetailAction(player, (Warning)w, currentAction), page).build();
    }

    @NotNull
    private String getDetailAction(Player player, Warning w, String currentAction) {
        if (this.warningAppealConfiguration.enabled && this.permission.has(player, this.warningAppealConfiguration.createAppealPermission)) {
            return GuiActionBuilder.builder().action("manage-warnings/view/detail").param("warningId", String.valueOf(w.getId())).build();
        }
        return "$NOOP";
    }

    public List<Warning> getItems(Player player, int offset, int amount) {
        return this.warnService.getWarnings(player.getUniqueId(), offset, amount, false);
    }
}

