/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.warnings.config;

import java.util.Optional;
import net.shortninja.staffplus.core.application.config.TimeUnitDurationTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;

public class WarningSeverityConfiguration {
    @ConfigProperty(value="name")
    private String name;
    @ConfigProperty(value="score")
    private int score;
    @ConfigProperty(value="expiresAfter")
    @ConfigTransformer(value={TimeUnitDurationTransformer.class})
    private long expirationDuration = -1L;
    @ConfigProperty(value="reason")
    private String reason;
    @ConfigProperty(value="reasonOverwriteEnabled")
    private boolean reasonOverwriteEnabled;

    public WarningSeverityConfiguration() {
    }

    public WarningSeverityConfiguration(String name, int score, long expirationDuration, String reason, boolean reasonOverwriteEnabled) {
        this.name = name;
        this.score = score;
        this.expirationDuration = expirationDuration;
        this.reason = reason;
        this.reasonOverwriteEnabled = reasonOverwriteEnabled;
    }

    public String getName() {
        return this.name;
    }

    public int getScore() {
        return this.score;
    }

    public long getExpirationDuration() {
        return this.expirationDuration;
    }

    public boolean isExpirationEnabled() {
        return this.expirationDuration > -1L;
    }

    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }

    public boolean isReasonOverwriteEnabled() {
        return this.reasonOverwriteEnabled;
    }

    public boolean isReasonSettable() {
        return !this.getReason().isPresent() || this.isReasonOverwriteEnabled();
    }

    public boolean hasDefaultReason() {
        return this.getReason().isPresent();
    }
}

