/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.warnings.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.SoundsConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigObjectList;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.common.Sounds;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommand;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.WarningSeverityConfiguration;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.WarningThresholdConfiguration;

@IocBean
public class WarningConfiguration {
    @ConfigProperty(value="warnings-module.enabled")
    private boolean enabled;
    @ConfigProperty(value="warnings-module.show-issuer")
    private boolean showIssuer;
    @ConfigProperty(value="warnings-module.sound")
    @ConfigTransformer(value={SoundsConfigTransformer.class})
    private Sounds sound;
    @ConfigProperty(value="warnings-module.user-notifications.enabled")
    private boolean notifyUser;
    @ConfigProperty(value="warnings-module.user-notifications.always-notify")
    private boolean alwaysNotifyUser;
    @ConfigProperty(value="warnings-module.thresholds")
    @ConfigObjectList(value=WarningThresholdConfiguration.class)
    private List<WarningThresholdConfiguration> thresholds = new ArrayList<WarningThresholdConfiguration>();
    @ConfigProperty(value="warnings-module.severity-levels")
    @ConfigObjectList(value=WarningSeverityConfiguration.class)
    private List<WarningSeverityConfiguration> severityLevels = new ArrayList<WarningSeverityConfiguration>();
    @ConfigProperty(value="warnings-module.actions")
    @ConfigObjectList(value=ConfiguredCommand.class)
    private List<ConfiguredCommand> actions = new ArrayList<ConfiguredCommand>();
    @ConfigProperty(value="commands:my-warnings")
    private List<String> myWarningsCmd;
    @ConfigProperty(value="permissions:view-my-warnings")
    private String myWarningsPermission;
    @ConfigProperty(value="permissions:warnings.notifications")
    private String notificationsPermission;

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isShowIssuer() {
        return this.showIssuer;
    }

    public Optional<Sounds> getSound() {
        return Optional.ofNullable(this.sound);
    }

    public boolean isAlwaysNotifyUser() {
        return this.alwaysNotifyUser;
    }

    public List<WarningThresholdConfiguration> getThresholds() {
        return this.thresholds;
    }

    public List<WarningSeverityConfiguration> getSeverityLevels() {
        return this.severityLevels;
    }

    public boolean isNotifyUser() {
        return this.notifyUser;
    }

    public String getMyWarningsPermission() {
        return this.myWarningsPermission;
    }

    public String getMyWarningsCmd() {
        return this.myWarningsCmd.get(0);
    }

    public List<ConfiguredCommand> getActions() {
        return this.actions;
    }

    public String getNotificationsPermission() {
        return this.notificationsPermission;
    }

    public Optional<WarningSeverityConfiguration> getSeverityConfiguration(String severityLevel) {
        return this.severityLevels.stream().filter(config -> config.getName().equalsIgnoreCase(severityLevel)).findFirst();
    }
}

