/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.warnings.cmd;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.WarnService;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.Warning;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.warnings.IWarning;
import org.bukkit.command.CommandSender;

@Command(command="commands:warns", permissions={"permissions:warnings.manage.view"}, description="List all warnings of a player", usage="[get] [player]", playerRetrievalStrategy=PlayerRetrievalStrategy.BOTH)
@IocBean(conditionalOnProperty="warnings-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class WarnsCmd
extends AbstractCmd {
    private final WarnService warnService;
    private final PlayerManager playerManager;

    public WarnsCmd(Messages messages, WarnService warnService, CommandService commandService, PlayerManager playerManager, PermissionHandler permissionHandler) {
        super(messages, permissionHandler, commandService);
        this.warnService = warnService;
        this.playerManager = playerManager;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        if (args.length == 2) {
            String argument = args[0];
            if (argument.equalsIgnoreCase("get")) {
                this.listWarnings(sender, player);
            } else {
                this.sendHelp(sender);
            }
        } else {
            this.sendHelp(sender);
        }
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 2;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.of(args[1]);
    }

    private void listWarnings(CommandSender sender, SppPlayer player) {
        List<Warning> warnings = this.warnService.getWarnings(player.getId(), true);
        for (String message : this.messages.warningsListStart) {
            this.messages.send(sender, message.replace("%longline%", this.messages.LONG_LINE).replace("%target%", player.getUsername()).replace("%warnings%", Integer.toString(warnings.size())), message.contains("%longline%") ? "" : this.messages.prefixWarnings);
        }
        for (int i = 0; i < warnings.size(); ++i) {
            IWarning warning = warnings.get(i);
            this.messages.send(sender, this.messages.warningsListEntry.replace("%count%", Integer.toString(i + 1)).replace("%reason%", warning.getReason()).replace("%issuer%", warning.getIssuerName()) + " &b" + warning.getSeverity() + ": &b" + warning.getScore(), this.messages.prefixWarnings);
        }
        for (String message : this.messages.warningsListEnd) {
            this.messages.send(sender, message.replace("%longline%", this.messages.LONG_LINE).replace("%target%", player.getUsername()).replace("%warnings%", Integer.toString(warnings.size())), message.contains("%longline%") ? "" : this.messages.prefixWarnings);
        }
    }

    private void sendHelp(CommandSender sender) {
        this.messages.send(sender, "&7" + this.messages.LONG_LINE, "");
        this.messages.send(sender, "&b/" + this.getName() + " get &7[player]", this.messages.prefixWarnings);
        this.messages.send(sender, "&7" + this.messages.LONG_LINE, "");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        if (args.length == 1) {
            return Stream.of("get").filter(s -> args[0].isEmpty() || s.contains(args[0])).collect(Collectors.toList());
        }
        if (args.length >= 1) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> args[1].isEmpty() || s.contains(args[1])).collect(Collectors.toList());
        }
        return super.tabComplete(sender, alias, args);
    }
}

