/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.warnings.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.WarnService;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.WarningConfiguration;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.WarningSeverityConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:warn", permissions={"permissions:warn"}, description="Issues a warning.", usage="[severity] [player] [reason]", playerRetrievalStrategy=PlayerRetrievalStrategy.BOTH)
@IocBean(conditionalOnProperty="warnings-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class WarnCmd
extends AbstractCmd {
    @ConfigProperty(value="permissions:warn-bypass")
    private String permissionWarnBypass;
    private final WarningConfiguration warningConfiguration;
    private final WarnService warnService;
    private final PlayerManager playerManager;
    private final PermissionHandler permissionHandler;
    private final BukkitUtils bukkitUtils;

    public WarnCmd(Messages messages, WarningConfiguration warningConfiguration, WarnService warnService, CommandService commandService, PlayerManager playerManager, PermissionHandler permissionHandler, BukkitUtils bukkitUtils) {
        super(messages, permissionHandler, commandService);
        this.warningConfiguration = warningConfiguration;
        this.warnService = warnService;
        this.playerManager = playerManager;
        this.permissionHandler = permissionHandler;
        this.bukkitUtils = bukkitUtils;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        List<WarningSeverityConfiguration> severityLevels = this.warningConfiguration.getSeverityLevels();
        if (severityLevels.isEmpty()) {
            String reason = JavaUtils.compileWords(args, 1);
            this.warnService.sendWarning(sender, player, reason);
            return true;
        }
        String severityLevel = args[0];
        String reason = JavaUtils.compileWords(args, 2);
        this.bukkitUtils.runTaskAsync(sender, () -> {
            WarningSeverityConfiguration severity = this.warningConfiguration.getSeverityConfiguration(severityLevel).orElseThrow(() -> new BusinessException("&CCannot find severity level: [" + severityLevel + "]", this.messages.prefixWarnings));
            this.warnService.sendWarning(sender, player, reason, severity);
        });
        return true;
    }

    @Override
    protected boolean canBypass(Player player) {
        return this.permissionHandler.has(player, this.permissionWarnBypass);
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        List<WarningSeverityConfiguration> severityLevels = this.warningConfiguration.getSeverityLevels();
        if (severityLevels.isEmpty()) {
            return 2;
        }
        if (args.length == 0) {
            return 3;
        }
        String severityLevel = args[0];
        WarningSeverityConfiguration severityConfiguration = this.warningConfiguration.getSeverityConfiguration(severityLevel).orElseThrow(() -> new BusinessException("&CCannot find severity level: [" + severityLevel + "]", this.messages.prefixWarnings));
        if (severityConfiguration.hasDefaultReason()) {
            return 2;
        }
        return 3;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        List<WarningSeverityConfiguration> severityLevels = this.warningConfiguration.getSeverityLevels();
        if (severityLevels.isEmpty()) {
            return Optional.of(args[0]);
        }
        return Optional.of(args[1]);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        List<WarningSeverityConfiguration> severityLevels = this.warningConfiguration.getSeverityLevels();
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            if (severityLevels.isEmpty()) {
                suggestions.addAll(this.playerManager.getAllPlayerNames());
            } else {
                List severityNames = severityLevels.stream().map(WarningSeverityConfiguration::getName).collect(Collectors.toList());
                suggestions.addAll(severityNames);
            }
            return suggestions.stream().filter(s -> args[0].isEmpty() || s.contains(args[0])).collect(Collectors.toList());
        }
        if (args.length == 2 && !severityLevels.isEmpty()) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> args[1].isEmpty() || s.contains(args[1])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

