/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.warnings;

import be.garagepoort.staffplusplus.craftbukkit.common.json.rayzr.JSONMessage;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.JsonSenderService;
import net.shortninja.staffplus.core.common.StaffPlusPlusJoinedEvent;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.WarnService;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.Warning;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.WarningConfiguration;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@IocBukkitListener
public class WarningNotifierListener
implements Listener {
    private final WarnService warnService;
    private final PermissionHandler permission;
    private final Messages messages;
    private final WarningConfiguration warningConfiguration;
    private final JsonSenderService jsonSenderService;

    public WarningNotifierListener(WarnService warnService, PermissionHandler permission, Messages messages, WarningConfiguration warningConfiguration, JsonSenderService jsonSenderService) {
        this.warnService = warnService;
        this.permission = permission;
        this.messages = messages;
        this.warningConfiguration = warningConfiguration;
        this.jsonSenderService = jsonSenderService;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void notifyWarnings(StaffPlusPlusJoinedEvent event) {
        if (!this.warningConfiguration.isNotifyUser()) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> {
            List<Warning> warnings = this.warnService.getWarnings(event.getPlayer().getUniqueId(), false);
            if (this.warningConfiguration.isAlwaysNotifyUser()) {
                if (!warnings.isEmpty()) {
                    this.sendMessage(event, warnings);
                }
            } else {
                List<Warning> unreadWarnings = warnings.stream().filter(w -> !w.isRead()).collect(Collectors.toList());
                if (!unreadWarnings.isEmpty()) {
                    this.sendMessage(event, unreadWarnings);
                }
            }
        });
    }

    private void sendMessage(StaffPlusPlusJoinedEvent event, List<Warning> unreadWarnings) {
        String notifyMessage = this.messages.warningsNotify.replace("%warningsCount%", String.valueOf(unreadWarnings.size()));
        JSONMessage message = JavaUtils.buildClickableMessage(notifyMessage, "View your warnings!", "Click to view your warnings", this.warningConfiguration.getMyWarningsCmd(), this.permission.has(event.getPlayer(), this.warningConfiguration.getMyWarningsPermission()));
        this.jsonSenderService.send(message, event.getPlayer());
    }
}

