/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.warnings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.actions.ActionService;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommandMapper;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.warn.threshold.ThresholdService;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.WarningActionFilter;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.WarningConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.warnings.IWarning;
import net.shortninja.staffplusplus.warnings.WarningAppealApprovedEvent;
import net.shortninja.staffplusplus.warnings.WarningCreatedEvent;
import net.shortninja.staffplusplus.warnings.WarningRemovedEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@IocBukkitListener
public class WarningListener
implements Listener {
    private static final String CREATION_CONTEXT = "creation";
    private final ActionService actionService;
    private final PlayerManager playerManager;
    private final ThresholdService thresholdService;
    private final ConfiguredCommandMapper configuredCommandMapper;
    private final BukkitUtils bukkitUtils;
    private final WarningConfiguration warningConfiguration;

    public WarningListener(ActionService actionService, PlayerManager playerManager, ThresholdService thresholdService, ConfiguredCommandMapper configuredCommandMapper, BukkitUtils bukkitUtils, WarningConfiguration warningConfiguration) {
        this.actionService = actionService;
        this.playerManager = playerManager;
        this.thresholdService = thresholdService;
        this.configuredCommandMapper = configuredCommandMapper;
        this.bukkitUtils = bukkitUtils;
        this.warningConfiguration = warningConfiguration;
    }

    @EventHandler
    public void executeCreateActions(WarningCreatedEvent warningCreatedEvent) {
        IWarning warning = warningCreatedEvent.getWarning();
        UUID targetUuid = warning.getTargetUuid();
        Optional<SppPlayer> target = this.playerManager.getOnOrOfflinePlayer(targetUuid);
        Optional<SppPlayer> issuer = this.playerManager.getOnOrOfflinePlayer(warning.getIssuerUuid());
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%issuer%", warning.getIssuerName());
        placeholders.put("%target%", warning.getTargetName());
        placeholders.put("%severity%", warning.getSeverity());
        placeholders.put("%score%", String.valueOf(warning.getScore()));
        placeholders.put("%reason%", String.valueOf(warning.getReason()));
        HashMap targets = new HashMap();
        target.ifPresent(sppPlayer -> targets.put("target", sppPlayer.getOfflinePlayer()));
        issuer.ifPresent(sppPlayer -> targets.put("issuer", sppPlayer.getOfflinePlayer()));
        this.bukkitUtils.runTaskAsync(() -> {
            this.actionService.createCommands(this.configuredCommandMapper.toCreateRequests(warning, this.warningConfiguration.getActions(), placeholders, targets, Collections.singletonList(new WarningActionFilter(warning, CREATION_CONTEXT))));
            target.ifPresent(sppPlayer -> this.thresholdService.handleThresholds(warning, (SppPlayer)sppPlayer));
        });
    }

    @EventHandler
    public void executeRemovalActions(WarningRemovedEvent warningRemovedEvent) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> {
            UUID targetUuid = warningRemovedEvent.getWarning().getTargetUuid();
            Optional<SppPlayer> target = this.playerManager.getOnOrOfflinePlayer(targetUuid);
            if (target.isPresent()) {
                this.actionService.rollbackActionable(warningRemovedEvent.getWarning());
            }
        });
    }

    @EventHandler
    public void executeAppealedActions(WarningAppealApprovedEvent warningAppealApprovedEvent) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> this.actionService.rollbackActionable(warningAppealApprovedEvent.getWarning()));
    }
}

