/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.warnings;

import java.util.Arrays;
import java.util.Map;
import net.shortninja.staffplus.core.domain.actions.ActionFilter;
import net.shortninja.staffplus.core.domain.actions.CreateStoredCommandRequest;
import net.shortninja.staffplusplus.warnings.IWarning;

public class WarningActionFilter
implements ActionFilter {
    private static final String SEVERITY = "severity";
    private static final String CONTEXT = "context";
    private final String context;
    private final IWarning warning;

    public WarningActionFilter(IWarning warning, String context) {
        this.warning = warning;
        this.context = context;
    }

    @Override
    public boolean isValidAction(CreateStoredCommandRequest createStoredCommandRequest, Map<String, String> filters) {
        return this.checkFilter(filters, SEVERITY, this.warning.getSeverity()) && this.checkFilter(filters, CONTEXT, this.context);
    }

    private boolean checkFilter(Map<String, String> filters, String filter, String value) {
        if (filters.containsKey(filter)) {
            return Arrays.asList(filters.get(filter).split(",")).contains(value.toLowerCase());
        }
        return true;
    }
}

