/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.warnings;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.domain.staff.appeals.Appeal;
import net.shortninja.staffplus.core.domain.staff.infractions.Infraction;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionType;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.WarningSeverityConfiguration;
import net.shortninja.staffplusplus.appeals.AppealStatus;
import net.shortninja.staffplusplus.appeals.AppealableType;
import net.shortninja.staffplusplus.appeals.IAppeal;
import net.shortninja.staffplusplus.investigate.evidence.Evidence;
import net.shortninja.staffplusplus.warnings.IWarning;

public class Warning
implements IWarning,
Infraction,
Evidence {
    private final UUID targetUuid;
    private final String targetName;
    private final String reason;
    private final int score;
    private final UUID issuerUuid;
    private final long time;
    private int id;
    private String issuerName;
    private String severity;
    private boolean read;
    private String serverName;
    private IAppeal appeal;
    private boolean expired;

    public Warning(UUID targetUuid, String targetName, String reason, String issuerName, UUID issuerUuid, long time, WarningSeverityConfiguration warningSeverityConfiguration) {
        this.targetUuid = targetUuid;
        this.targetName = targetName;
        this.reason = reason;
        this.issuerName = issuerName;
        this.issuerUuid = issuerUuid;
        this.time = time;
        this.score = warningSeverityConfiguration.getScore();
        this.severity = warningSeverityConfiguration.getName();
    }

    public Warning(UUID targetUuid, String targetName, int id, String reason, String issuerName, UUID issuerUuid, long time, int score, String severity, boolean read, String serverName, Appeal appeal, boolean expired) {
        this.targetUuid = targetUuid;
        this.targetName = targetName;
        this.reason = reason;
        this.issuerName = issuerName;
        this.issuerUuid = issuerUuid;
        this.time = time;
        this.id = id;
        this.score = score;
        this.severity = severity;
        this.read = read;
        this.serverName = serverName;
        this.appeal = appeal;
        this.expired = expired;
    }

    public Warning(UUID targetUuid, String playerName, String reason, String issuerName, UUID issuerUuid, long currentTimeMillis) {
        this.targetUuid = targetUuid;
        this.targetName = playerName;
        this.reason = reason;
        this.issuerName = issuerName;
        this.issuerUuid = issuerUuid;
        this.time = currentTimeMillis;
        this.score = 0;
    }

    @Override
    public UUID getTargetUuid() {
        return this.targetUuid;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public String getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    @Override
    public UUID getIssuerUuid() {
        return this.issuerUuid;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getEvidenceType() {
        return "WARNING";
    }

    @Override
    public String getDescription() {
        return this.severity + " " + this.reason;
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @Override
    public String getSeverity() {
        return this.severity;
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.time), ZoneId.systemDefault());
    }

    public boolean isRead() {
        return this.read;
    }

    @Override
    public String getActionableType() {
        return "WARNING";
    }

    @Override
    public InfractionType getInfractionType() {
        return InfractionType.WARNING;
    }

    @Override
    public Long getCreationTimestamp() {
        return this.time;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    public Optional<IAppeal> getAppeal() {
        return Optional.ofNullable(this.appeal);
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void setAppeal(IAppeal appeal) {
        this.appeal = appeal;
    }

    @Override
    public AppealableType getType() {
        return AppealableType.WARNING;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public boolean hasApprovedAppeal() {
        return this.getAppeal().map(a -> a.getStatus() == AppealStatus.APPROVED).orElse(false);
    }
}

