/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.appeals;

import be.garagepoort.staffplusplus.craftbukkit.common.json.rayzr.JSONMessage;
import java.util.UUID;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.warn.appeals.WarningAppealConfiguration;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.Warning;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.config.ManageWarningsConfiguration;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.database.WarnRepository;
import net.shortninja.staffplusplus.appeals.AppealApprovedEvent;
import net.shortninja.staffplusplus.appeals.AppealRejectedEvent;
import net.shortninja.staffplusplus.appeals.AppealableType;
import net.shortninja.staffplusplus.appeals.AppealedEvent;
import net.shortninja.staffplusplus.appeals.IAppeal;
import net.shortninja.staffplusplus.warnings.WarningAppealApprovedEvent;
import net.shortninja.staffplusplus.warnings.WarningAppealRejectedEvent;
import net.shortninja.staffplusplus.warnings.WarningAppealedEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class WarningAppealedListener
implements Listener {
    private final ManageWarningsConfiguration manageWarningsConfiguration;
    private final Messages messages;
    private final WarningAppealConfiguration warningAppealConfiguration;
    private final PlayerManager playerManager;
    private final WarnRepository warnRepository;

    public WarningAppealedListener(ManageWarningsConfiguration manageWarningsConfiguration, Messages messages, WarningAppealConfiguration warningAppealConfiguration, PlayerManager playerManager, WarnRepository warnRepository) {
        this.manageWarningsConfiguration = manageWarningsConfiguration;
        this.messages = messages;
        this.warningAppealConfiguration = warningAppealConfiguration;
        this.playerManager = playerManager;
        this.warnRepository = warnRepository;
    }

    @EventHandler
    public void handleAppealedEvent(AppealedEvent appealedEvent) {
        if (appealedEvent.getAppealable().getType() != AppealableType.WARNING) {
            return;
        }
        Warning warning = (Warning)appealedEvent.getAppealable();
        warning.getAppeal().ifPresent(appeal -> {
            this.playerManager.getOnlinePlayer(appeal.getAppealerUuid()).ifPresent(appealer -> {
                this.sendAppealedMessageToStaff(warning, appealer.getPlayer());
                String message = this.messages.appealCreated.replace("%reason%", appeal.getReason());
                this.messages.send((CommandSender)appealer.getPlayer(), message, this.messages.prefixWarnings);
            });
            BukkitUtils.sendEvent(new WarningAppealedEvent(warning));
        });
    }

    @EventHandler
    public void handleAppealApproved(AppealApprovedEvent appealApprovedEvent) {
        if (appealApprovedEvent.getAppeal().getType() != AppealableType.WARNING) {
            return;
        }
        IAppeal appeal = appealApprovedEvent.getAppeal();
        Warning warning = this.warnRepository.findWarning(appeal.getAppealableId()).orElseThrow(() -> new BusinessException("No warning found."));
        this.sendMessageToPlayer(appeal.getAppealerUuid(), this.messages.appealApproved);
        this.sendMessageToPlayer(appeal.getResolverUuid(), this.messages.appealApprove);
        BukkitUtils.sendEvent(new WarningAppealApprovedEvent(appeal, warning));
    }

    @EventHandler
    public void handleAppealRejected(AppealRejectedEvent appealRejectedEvent) {
        if (appealRejectedEvent.getAppeal().getType() != AppealableType.WARNING) {
            return;
        }
        IAppeal appeal = appealRejectedEvent.getAppeal();
        Warning warning = this.warnRepository.findWarning(appeal.getAppealableId()).orElseThrow(() -> new BusinessException("No warning found."));
        this.sendMessageToPlayer(appeal.getAppealerUuid(), this.messages.appealRejected);
        this.sendMessageToPlayer(appeal.getResolverUuid(), this.messages.appealReject);
        BukkitUtils.sendEvent(new WarningAppealRejectedEvent(appeal, warning));
    }

    private void sendMessageToPlayer(UUID appealerUuid, String appealApproved) {
        this.playerManager.getOnlinePlayer(appealerUuid).ifPresent(sppPlayer -> this.messages.send((CommandSender)sppPlayer.getPlayer(), appealApproved, this.messages.prefixWarnings));
    }

    private void sendAppealedMessageToStaff(Warning warning, Player appealer) {
        String manageWarningsCommand = this.manageWarningsConfiguration.commandManageWarningsGui.get(0) + " " + warning.getTargetName();
        JSONMessage jsonMessage = JavaUtils.buildClickableMessage(appealer.getName() + " has appealed a warning", "View warnings!", "Click to open the warnings view", manageWarningsCommand, true);
        this.messages.sendGroupMessage(jsonMessage, this.warningAppealConfiguration.permissionNotifications);
    }
}

