/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.warn.appeals;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.common.utils.Validator;
import net.shortninja.staffplus.core.domain.actions.ActionService;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.appeals.Appeal;
import net.shortninja.staffplus.core.domain.staff.appeals.AppealService;
import net.shortninja.staffplus.core.domain.staff.warn.appeals.WarningAppealConfiguration;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.WarnService;
import net.shortninja.staffplus.core.domain.staff.warn.warnings.Warning;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class WarningAppealGuiController {
    private static final String CANCEL = "cancel";
    private static final int PAGE_SIZE = 45;
    private final AppealService appealService;
    private final WarnService warnService;
    private final Messages messages;
    private final OnlineSessionsManager sessionManager;
    private final Options options;
    private final BukkitUtils bukkitUtils;
    private final WarningAppealConfiguration warningAppealConfiguration;
    private final ActionService actionService;
    private final PermissionHandler permission;
    private final PlayerManager playerManager;

    public WarningAppealGuiController(AppealService appealService, WarnService warnService, Messages messages, OnlineSessionsManager sessionManager, Options options, BukkitUtils bukkitUtils, WarningAppealConfiguration warningAppealConfiguration, ActionService actionService, PermissionHandler permission, PlayerManager playerManager) {
        this.appealService = appealService;
        this.warnService = warnService;
        this.messages = messages;
        this.sessionManager = sessionManager;
        this.options = options;
        this.bukkitUtils = bukkitUtils;
        this.warningAppealConfiguration = warningAppealConfiguration;
        this.actionService = actionService;
        this.permission = permission;
        this.playerManager = playerManager;
    }

    @GuiAction(value="manage-warning-appeals/view/detail")
    public AsyncGui<GuiTemplate> getAppealDetail(@GuiParam(value="appealId") int appealId) {
        return AsyncGui.async(() -> {
            Appeal appeal = this.appealService.getAppeal(appealId);
            Warning warning = this.warnService.getWarning(appeal.getAppealableId());
            List rollbackCommands = this.actionService.getActions(warning).stream().filter(s -> s.isExecuted() && s.isRollbackable() && !s.isRollbacked()).map(s -> s.getRollbackCommand().get().getCommand()).collect(Collectors.toList());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("appeal", appeal);
            params.put("rollbackCommands", rollbackCommands);
            return GuiTemplate.template("gui/warnings/appeal-detail.ftl", params);
        });
    }

    @GuiAction(value="manage-warnings/view/appealed-warnings")
    public AsyncGui<GuiTemplate> appealedWarningsOverview(@GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            List<Warning> warnings = this.warnService.getAppealedWarnings(page * 45, 45);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("warnings", warnings);
            return GuiTemplate.template("gui/warnings/appealed-warnings-overview.ftl", params);
        });
    }

    @GuiAction(value="manage-warning-appeals/view/create/reason-select")
    public GuiTemplate getCreateAppealReasonSelectView(@GuiParam(value="warningId") int warningId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("action", "manage-warning-appeals/create?warningId=" + warningId);
        params.put("reasons", this.warningAppealConfiguration.appealReasons);
        return GuiTemplate.template("gui/appeals/appeal-reason-select.ftl", params);
    }

    @GuiAction(value="manage-warning-appeals/view/create/reason-chat")
    public void getCreateAppealReasonChatView(Player player, @GuiParam(value="warningId") int warningId) {
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        Warning warning = this.warnService.getWarning(warningId);
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6         You have chosen to appeal this warning", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6            Type your appeal reason in chat", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6         Type \"cancel\" to cancel appealing ", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        PlayerSession playerSession = this.sessionManager.get(player);
        playerSession.setChatAction((player1, input) -> {
            if (input.equalsIgnoreCase(CANCEL)) {
                this.messages.send((CommandSender)player, "&CYou have cancelled your appeal", this.messages.prefixWarnings);
                return;
            }
            Validator.validator(player).validateAnyPermission(this.warningAppealConfiguration.createAppealPermission).validateNotEmpty(input, "Reason for appeal can not be empty");
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.appealService.addAppeal(sppPlayer, warning, input));
        });
    }

    @GuiAction(value="manage-warning-appeals/create")
    public void createAppeal(Player player, @GuiParam(value="warningId") int warningId, @GuiParam(value="reason") String reason) {
        Validator.validator(player).validateAnyPermission(this.warningAppealConfiguration.createAppealPermission).validateNotEmpty(reason, "Reason for appeal can not be empty");
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            Warning warning = this.warnService.getWarning(warningId);
            this.appealService.addAppeal(sppPlayer, warning, reason);
        });
    }

    @GuiAction(value="manage-warning-appeals/approve")
    public void approveAppeal(Player player, @GuiParam(value="appealId") int appealId) {
        this.permission.validate((CommandSender)player, this.warningAppealConfiguration.approveAppealPermission);
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        if (this.warningAppealConfiguration.resolveReasonEnabled) {
            this.messages.send((CommandSender)player, "&1===================================================", this.messages.prefixWarnings);
            this.messages.send((CommandSender)player, "&6       You have chosen to approve this appeal", this.messages.prefixWarnings);
            this.messages.send((CommandSender)player, "&6Type your closing reason in chat to approve the appeal", this.messages.prefixWarnings);
            this.messages.send((CommandSender)player, "&6      Type \"cancel\" to cancel approving the appeal ", this.messages.prefixWarnings);
            this.messages.send((CommandSender)player, "&1===================================================", this.messages.prefixWarnings);
            PlayerSession playerSession = this.sessionManager.get(player);
            playerSession.setChatAction((player1, message) -> {
                if (message.equalsIgnoreCase(CANCEL)) {
                    this.messages.send((CommandSender)player, "&CYou have cancelled approving this appeal", this.messages.prefixWarnings);
                    return;
                }
                this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.warnService.approveAppeal(sppPlayer, appealId, message));
            });
        } else {
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.warnService.approveAppeal(sppPlayer, appealId));
        }
    }

    @GuiAction(value="manage-warning-appeals/reject")
    public void rejectAppeal(Player player, @GuiParam(value="appealId") int appealId) {
        this.permission.validate((CommandSender)player, this.warningAppealConfiguration.rejectAppealPermission);
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        if (this.warningAppealConfiguration.resolveReasonEnabled) {
            this.messages.send((CommandSender)player, "&1==================================================", this.messages.prefixWarnings);
            this.messages.send((CommandSender)player, "&6        You have chosen to reject this appeal", this.messages.prefixWarnings);
            this.messages.send((CommandSender)player, "&6Type your closing reason in chat to reject the appeal", this.messages.prefixWarnings);
            this.messages.send((CommandSender)player, "&6        Type \"cancel\" to cancel closing the appeal ", this.messages.prefixWarnings);
            this.messages.send((CommandSender)player, "&1==================================================", this.messages.prefixWarnings);
            PlayerSession playerSession = this.sessionManager.get(player);
            playerSession.setChatAction((player1, message) -> {
                if (message.equalsIgnoreCase(CANCEL)) {
                    this.messages.send((CommandSender)player, "&CYou have cancelled rejecting this appeal", this.messages.prefixWarnings);
                    return;
                }
                this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.warnService.rejectAppeal(sppPlayer, appealId, message));
            });
        } else {
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.warnService.rejectAppeal(sppPlayer, appealId));
        }
    }
}

