/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish.listeners;

import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;

@IocBukkitListener
public class VanishNormalChestOpening
implements Listener {
    @ConfigProperty(value="vanish-module.normal-chest-opening")
    private boolean normalChestOpening;
    @ConfigProperty(value="vanish-module.normal-chest-interaction")
    private boolean normalChestInteraction;
    private final OnlineSessionsManager sessionManager;

    public VanishNormalChestOpening(OnlineSessionsManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        PlayerSession playerSession = this.sessionManager.get(player);
        if (playerSession.isVanished() && this.checkingChest(event) && !this.normalChestOpening) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        PlayerSession playerSession = this.sessionManager.get(player);
        if (event.getClickedInventory() != null && event.getClickedInventory().getHolder() != null && event.getClickedInventory().getHolder() instanceof Container && playerSession.isVanished() && !this.normalChestInteraction) {
            event.setCancelled(true);
        }
    }

    private boolean checkingChest(PlayerInteractEvent event) {
        return event.getClickedBlock() != null && event.getClickedBlock().getState() instanceof Container;
    }
}

