/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish.listeners;

import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocContainer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.OnLoad;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.StaffPlusPlusJoinedEvent;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.vanish.VanishService;
import net.shortninja.staffplus.core.domain.staff.vanish.gui.VanishPlayersBukkitService;
import net.shortninja.staffplusplus.session.IPlayerSession;
import net.shortninja.staffplusplus.session.SessionManager;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.LazyMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@IocBukkitListener(conditionalOnProperty="vanish-module.enabled=true")
@IocMultiProvider(value={OnLoad.class})
public class VanishJoinListener
implements Listener,
OnLoad {
    private final VanishPlayersBukkitService vanishPlayersBukkitService;
    private final PlayerSettingsRepository playerSettingsRepository;
    private final VanishService vanishService;
    private final StaffPlusPlus staffPlusPlus;
    private final SessionManager sessionManager;
    private final PlayerManager playerManager;

    public VanishJoinListener(VanishPlayersBukkitService vanishPlayersBukkitService, PlayerSettingsRepository playerSettingsRepository, VanishService vanishService, @InjectTubingPlugin StaffPlusPlus staffPlusPlus, SessionManager sessionManager, PlayerManager playerManager) {
        this.vanishPlayersBukkitService = vanishPlayersBukkitService;
        this.playerSettingsRepository = playerSettingsRepository;
        this.vanishService = vanishService;
        this.staffPlusPlus = staffPlusPlus;
        this.sessionManager = sessionManager;
        this.playerManager = playerManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void hideJoinMessage(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.vanishPlayersBukkitService.updateVanish(player);
        PlayerSettings playerSettings = this.playerSettingsRepository.get((OfflinePlayer)player);
        if (playerSettings.isVanished()) {
            this.vanishService.addVanish(player, playerSettings.getVanishType(), true);
            event.setJoinMessage("");
            player.setMetadata("vanished", (MetadataValue)new FixedMetadataValue((Plugin)this.staffPlusPlus, (Object)true));
        }
    }

    @EventHandler
    public void setMetaData(StaffPlusPlusJoinedEvent event) {
        this.setVanishMetaData(event.getPlayer());
    }

    @Override
    public void load(IocContainer iocContainer) {
        this.playerManager.getOnlinePlayers().forEach(this::setVanishMetaData);
    }

    private void setVanishMetaData(Player player) {
        player.setMetadata("vanished", (MetadataValue)new LazyMetadataValue((Plugin)this.staffPlusPlus, LazyMetadataValue.CacheStrategy.NEVER_CACHE, () -> {
            IPlayerSession session = this.sessionManager.get(player);
            return session.getVanishType() == VanishType.TOTAL || session.getVanishType() == VanishType.LIST;
        }));
    }
}

