/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish.listeners;

import github.scarsz.discordsrv.DiscordSRV;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplusplus.vanish.VanishOffEvent;
import net.shortninja.staffplusplus.vanish.VanishOnEvent;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@IocBean(conditionalOnProperty="vanish-module.join-leave-message-enabled=true")
public class VanishJoinLeaveDiscordSrvMessageListener
implements Listener {
    @ConfigProperty(value="vanish-module.join-leave-message-enabled")
    private boolean vanishMessagesEnabled;
    @ConfigProperty(value="%lang%:vanish-join-message")
    private String vanishJoinMessage;
    @ConfigProperty(value="%lang%:vanish-leave-message")
    private String vanishLeaveMessage;

    public VanishJoinLeaveDiscordSrvMessageListener() {
        Plugin discordSrvPlugin = Bukkit.getPluginManager().getPlugin("DiscordSRV");
        if (discordSrvPlugin == null || !discordSrvPlugin.isEnabled()) {
            return;
        }
        StaffPlusPlus.get().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)StaffPlusPlus.get());
    }

    @EventHandler
    public void onVanish(VanishOnEvent event) {
        if (!this.vanishMessagesEnabled || event.isOnJoin() || event.getType() != VanishType.LIST && event.getType() != VanishType.TOTAL) {
            return;
        }
        DiscordSRV.getPlugin().sendLeaveMessage(event.getPlayer(), this.vanishLeaveMessage.replace("%player%", event.getPlayer().getName()));
    }

    @EventHandler
    public void onUnvanish(VanishOffEvent event) {
        if (!this.vanishMessagesEnabled || event.getType() != VanishType.LIST && event.getType() != VanishType.TOTAL) {
            return;
        }
        DiscordSRV.getPlugin().sendJoinMessage(event.getPlayer(), this.vanishJoinMessage.replace("%player%", event.getPlayer().getName()));
    }
}

