/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish.listeners;

import java.util.Set;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.config.transformers.ToMaterials;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;

@IocBukkitListener(conditionalOnProperty="vanish-module.enabled=true")
public class VanishCancelInteraction
implements Listener {
    private final OnlineSessionsManager sessionManager;
    @ConfigProperty(value="vanish-module.cancelled-interaction-types")
    @ConfigTransformer(value={ToMaterials.class})
    private Set<Material> cancelledInteractions;

    public VanishCancelInteraction(OnlineSessionsManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        Player player;
        PlayerSession playerSession;
        if (event.getClickedBlock() != null && (playerSession = this.sessionManager.get(player = event.getPlayer())).isVanished() && this.cancelledInteractions.contains(event.getClickedBlock().getBlockData().getMaterial())) {
            event.setCancelled(true);
        }
    }
}

