/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish.listeners;

import java.util.Optional;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.projectiles.ProjectileSource;

@IocBukkitListener(conditionalOnProperty="vanish-module.damage=false")
public class VanishCancelGiveDamage
implements Listener {
    private final OnlineSessionsManager sessionManager;

    public VanishCancelGiveDamage(OnlineSessionsManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        PlayerSession session;
        Optional<Player> damager = this.getDamager(event.getDamager());
        if (damager.isPresent() && damager.get().isOnline() && (session = this.sessionManager.get(damager.get())).isVanished()) {
            event.setCancelled(true);
        }
    }

    public Optional<Player> getDamager(Entity damager) {
        ProjectileSource shooter;
        if (damager instanceof Player) {
            return Optional.of((Player)damager);
        }
        if (damager instanceof Arrow && (shooter = ((Arrow)damager).getShooter()) instanceof Player) {
            return Optional.of((Player)shooter);
        }
        return Optional.empty();
    }
}

