/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish.gui;

import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.vanish.VanishConfiguration;
import net.shortninja.staffplus.core.domain.staff.vanish.VanishStrategy;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.vanish.VanishOffEvent;
import net.shortninja.staffplusplus.vanish.VanishOnEvent;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class VanishPlayersBukkitService
implements Listener {
    private final List<VanishStrategy> vanishStrategies;
    private final VanishConfiguration vanishConfiguration;
    private final PlayerManager playerManager;

    public VanishPlayersBukkitService(@IocMulti(value=VanishStrategy.class) List<VanishStrategy> vanishStrategies, VanishConfiguration vanishConfiguration, PlayerManager playerManager) {
        this.vanishStrategies = vanishStrategies;
        this.vanishConfiguration = vanishConfiguration;
        this.playerManager = playerManager;
    }

    @EventHandler
    public void onVanish(VanishOnEvent event) {
        VanishType vanishType = event.getType();
        this.vanishPlayers(event.getPlayer(), vanishType);
    }

    @EventHandler
    public void onUnvanish(VanishOffEvent event) {
        this.playerManager.getOnlinePlayer(event.getPlayer().getUniqueId()).ifPresent(sppPlayer -> this.vanishStrategies.stream().filter(s -> s.getVanishType() == event.getType()).forEach(v -> v.unvanish((SppPlayer)sppPlayer)));
    }

    private void vanishPlayers(Player player, VanishType vanishType) {
        this.playerManager.getOnlinePlayer(player.getUniqueId()).ifPresent(sppPlayer -> this.vanishStrategies.stream().filter(v -> v.getVanishType() == vanishType).findFirst().orElseThrow(() -> new BusinessException("&CNo Suitable vanish strategy found for type [" + (Object)((Object)vanishType) + "]")).vanish((SppPlayer)sppPlayer));
    }

    public void updateVanish(Player player) {
        this.playerManager.getOnlinePlayer(player.getUniqueId()).ifPresent(sppPlayer -> {
            if (!this.vanishConfiguration.enabled) {
                return;
            }
            this.vanishStrategies.forEach(v -> v.updateVanish((SppPlayer)sppPlayer));
        });
    }
}

