/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish.gui;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.nightvision.NightVisionService;
import net.shortninja.staffplus.core.domain.staff.vanish.VanishConfiguration;
import net.shortninja.staffplusplus.vanish.VanishOffEvent;
import net.shortninja.staffplusplus.vanish.VanishOnEvent;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class VanishNightVisionListener
implements Listener {
    private final VanishConfiguration vanishConfiguration;
    private final NightVisionService nightVisionService;
    private final BukkitUtils bukkitUtils;

    public VanishNightVisionListener(VanishConfiguration vanishConfiguration, NightVisionService nightVisionService, BukkitUtils bukkitUtils) {
        this.vanishConfiguration = vanishConfiguration;
        this.nightVisionService = nightVisionService;
        this.bukkitUtils = bukkitUtils;
    }

    @EventHandler
    public void onVanish(VanishOnEvent event) {
        VanishType vanishType = event.getType();
        if (this.vanishConfiguration.nightVisionEnabled && (vanishType == VanishType.TOTAL || vanishType == VanishType.PLAYER)) {
            this.bukkitUtils.runTaskLater(() -> this.nightVisionService.turnOnNightVision("VANISH", event.getPlayer()));
        }
    }

    @EventHandler
    public void onUnvanish(VanishOffEvent event) {
        this.bukkitUtils.runTaskLater(() -> this.nightVisionService.turnOffNightVision("VANISH", event.getPlayer()));
    }
}

