/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.transformers.ToEnum;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.vanish.VanishConfiguration;
import net.shortninja.staffplus.core.domain.staff.vanish.VanishService;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:vanish", permissions={"permissions:vanish"}, description="Enables or disables the type of vanish for the player.", usage="[total | list | player] {player} {enable | disable}", playerRetrievalStrategy=PlayerRetrievalStrategy.ONLINE)
@IocBean(conditionalOnProperty="vanish-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class VanishCmd
extends AbstractCmd {
    public static final String ENABLE = "enable";
    private final VanishService vanishService;
    private final PermissionHandler permissionHandler;
    private final PlayerManager playerManager;
    private final VanishConfiguration vanishConfiguration;
    private final OnlineSessionsManager sessionManager;
    private final BukkitUtils bukkitUtils;
    @ConfigProperty(value="permissions:vanish-others.total")
    private String permissionVanishOthersTotal;
    @ConfigProperty(value="permissions:vanish-others.list")
    private String permissionVanishOthersList;
    @ConfigProperty(value="permissions:vanish-others.player")
    private String permissionVanishOthersPlayer;
    @ConfigProperty(value="vanish-module.default-mode")
    @ConfigTransformer(value={ToEnum.class})
    private VanishType defaultVanishType;

    public VanishCmd(Messages messages, VanishService vanishService, CommandService commandService, PermissionHandler permissionHandler, PlayerManager playerManager, VanishConfiguration vanishConfiguration, OnlineSessionsManager sessionManager, BukkitUtils bukkitUtils) {
        super(messages, permissionHandler, commandService);
        this.vanishService = vanishService;
        this.permissionHandler = permissionHandler;
        this.playerManager = playerManager;
        this.vanishConfiguration = vanishConfiguration;
        this.sessionManager = sessionManager;
        this.bukkitUtils = bukkitUtils;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer targetPlayer, Map<String, String> optionalParameters) {
        VanishType vanishType;
        VanishType vanishType2 = vanishType = args.length != 0 ? VanishType.valueOf(args[0].toUpperCase()) : this.defaultVanishType;
        if (args.length >= 3) {
            this.permissionHandler.validateAny(sender, this.permissionVanishOthersPlayer, this.permissionVanishOthersTotal, this.permissionVanishOthersList);
            String enableDisable = args[2];
            this.validatePermissionOther(sender, vanishType);
            this.bukkitUtils.runTaskAsync(sender, () -> {
                if (enableDisable.equalsIgnoreCase(ENABLE)) {
                    this.vanish(targetPlayer.getPlayer(), vanishType);
                } else {
                    this.vanishService.removeVanish(targetPlayer.getPlayer());
                }
            });
            return true;
        }
        if (args.length == 2) {
            this.validatePermissionOther(sender, vanishType);
            this.bukkitUtils.runTaskAsync(sender, () -> this.vanish(targetPlayer.getPlayer(), vanishType));
            return true;
        }
        this.validateIsPlayer(sender);
        this.validatePermissionSelf(sender, vanishType);
        this.bukkitUtils.runTaskAsync(sender, () -> this.vanish((Player)sender, vanishType));
        return true;
    }

    private void validatePermissionSelf(CommandSender sender, VanishType vanishType) {
        switch (vanishType) {
            case LIST: {
                this.permissionHandler.validate(sender, this.vanishConfiguration.permissionVanishList);
                break;
            }
            case PLAYER: {
                this.permissionHandler.validate(sender, this.vanishConfiguration.permissionVanishPlayer);
                break;
            }
            case TOTAL: {
                this.permissionHandler.validate(sender, this.vanishConfiguration.permissionVanishTotal);
            }
        }
    }

    private void validatePermissionOther(CommandSender sender, VanishType vanishType) {
        switch (vanishType) {
            case LIST: {
                this.permissionHandler.validate(sender, this.permissionVanishOthersList);
                break;
            }
            case PLAYER: {
                this.permissionHandler.validate(sender, this.permissionVanishOthersPlayer);
                break;
            }
            case TOTAL: {
                this.permissionHandler.validate(sender, this.permissionVanishOthersTotal);
            }
        }
    }

    private void vanish(Player player, VanishType vanishType) {
        switch (vanishType) {
            case LIST: 
            case PLAYER: 
            case TOTAL: {
                this.setVanish(vanishType, player);
                break;
            }
            case NONE: {
                this.vanishService.removeVanish(player);
                break;
            }
            default: {
                throw new BusinessException("No vanishtype " + vanishType.name());
            }
        }
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            return 0;
        }
        return 2;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        if (args.length > 1) {
            return Optional.of(args[1]);
        }
        if (sender instanceof Player) {
            return Optional.of(sender.getName());
        }
        return Optional.empty();
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        if (args.length == 1) {
            return this.getAllowedVanishTypes(sender).stream().map(Enum::name).filter(s -> args[0].isEmpty() || s.contains(args[0])).collect(Collectors.toList());
        }
        if (this.permissionHandler.hasAny(sender, this.permissionVanishOthersPlayer, this.permissionVanishOthersTotal, this.permissionVanishOthersList)) {
            if (args.length == 2) {
                return this.playerManager.getAllPlayerNames().stream().filter(s -> args[1].isEmpty() || s.contains(args[1])).collect(Collectors.toList());
            }
            if (args.length == 3) {
                return Stream.of(ENABLE, "disable").filter(s -> args[2].isEmpty() || s.contains(args[2])).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private List<VanishType> getAllowedVanishTypes(CommandSender player) {
        ArrayList<VanishType> allowedVanishTypes = new ArrayList<VanishType>();
        if (this.permissionHandler.has(player, this.vanishConfiguration.permissionVanishTotal)) {
            allowedVanishTypes.add(VanishType.TOTAL);
        }
        if (this.permissionHandler.has(player, this.vanishConfiguration.permissionVanishList)) {
            allowedVanishTypes.add(VanishType.LIST);
        }
        if (this.permissionHandler.has(player, this.vanishConfiguration.permissionVanishPlayer)) {
            allowedVanishTypes.add(VanishType.PLAYER);
        }
        return allowedVanishTypes;
    }

    private void setVanish(VanishType vanishType, Player player) {
        PlayerSession session = this.sessionManager.get(player);
        if (session.getVanishType() != vanishType) {
            this.vanishService.addVanish(player, vanishType);
        } else {
            this.vanishService.removeVanish(player);
        }
    }
}

