/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish.gui;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.vanish.VanishOffEvent;
import net.shortninja.staffplusplus.vanish.VanishOnEvent;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class VanishChatNotifier
implements Listener {
    private final Messages messages;

    public VanishChatNotifier(Messages messages) {
        this.messages = messages;
    }

    @EventHandler
    public void onVanish(VanishOnEvent vanishOnEvent) {
        String message = this.getMessage(vanishOnEvent.getType()).replace("%status%", this.messages.enabled);
        if (StringUtils.isNotEmpty(message)) {
            this.messages.send((CommandSender)vanishOnEvent.getPlayer(), message, this.messages.prefixGeneral);
        }
    }

    @EventHandler
    public void onUnVanish(VanishOffEvent vanishOffEvent) {
        String message = this.getMessage(vanishOffEvent.getType()).replace("%status%", this.messages.disabled);
        if (StringUtils.isNotEmpty(message)) {
            this.messages.send((CommandSender)vanishOffEvent.getPlayer(), message, this.messages.prefixGeneral);
        }
    }

    private String getMessage(VanishType vanishType) {
        switch (vanishType) {
            case LIST: {
                return this.messages.listVanish;
            }
            case PLAYER: {
                return this.messages.playerVanish;
            }
            case TOTAL: {
                return this.messages.totalVanish;
            }
        }
        return "";
    }
}

