/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish.gui;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.domain.chat.ChatInterceptor;
import net.shortninja.staffplus.core.domain.staff.vanish.VanishService;
import org.bukkit.command.CommandSender;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@IocBean(conditionalOnProperty="vanish-module.enabled=true && vanish-module.chat=true")
@IocMultiProvider(value={ChatInterceptor.class})
public class VanishChatInterceptor
implements ChatInterceptor {
    @ConfigProperty(value="%lang%:vanish-chat-prevented")
    private String chatPrevented;
    private final VanishService vanishService;
    private final Messages messages;

    public VanishChatInterceptor(VanishService vanishService, Messages messages) {
        this.vanishService = vanishService;
        this.messages = messages;
    }

    @Override
    public boolean intercept(AsyncPlayerChatEvent event) {
        if (this.vanishService.isVanished(event.getPlayer())) {
            this.messages.send((CommandSender)event.getPlayer(), this.chatPrevented, this.messages.prefixGeneral);
            return true;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 4;
    }
}

