/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.vanish.VanishConfiguration;
import net.shortninja.staffplusplus.vanish.VanishOffEvent;
import net.shortninja.staffplusplus.vanish.VanishOnEvent;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@IocBean
public class VanishService {
    private final PlayerSettingsRepository playerSettingsRepository;
    private final VanishConfiguration vanishConfiguration;
    private static final Map<UUID, VanishType> vanishCache = new HashMap<UUID, VanishType>();

    public VanishService(PlayerSettingsRepository playerSettingsRepository, VanishConfiguration vanishConfiguration) {
        this.playerSettingsRepository = playerSettingsRepository;
        this.vanishConfiguration = vanishConfiguration;
    }

    public void addVanish(Player player, VanishType vanishType) {
        this.addVanish(player, vanishType, false);
    }

    public void addVanish(Player player, VanishType vanishType, boolean onJoin) {
        if (!this.vanishConfiguration.enabled) {
            return;
        }
        if (vanishCache.getOrDefault(player.getUniqueId(), VanishType.NONE) == vanishType) {
            return;
        }
        PlayerSettings settings = this.playerSettingsRepository.get((OfflinePlayer)player);
        settings.setVanishType(vanishType);
        this.playerSettingsRepository.save(settings);
        vanishCache.put(player.getUniqueId(), vanishType);
        BukkitUtils.sendEvent(new VanishOnEvent(vanishType, player, onJoin));
    }

    public void removeVanish(Player player) {
        if (!this.vanishConfiguration.enabled) {
            return;
        }
        PlayerSettings session = this.playerSettingsRepository.get((OfflinePlayer)player);
        VanishType vanishType = session.getVanishType();
        session.setVanishType(VanishType.NONE);
        vanishCache.put(player.getUniqueId(), VanishType.NONE);
        this.playerSettingsRepository.save(session);
        BukkitUtils.sendEvent(new VanishOffEvent(vanishType, player));
    }

    public void clearCache(Player player) {
        vanishCache.remove(player.getUniqueId());
    }

    public boolean isVanished(Player player) {
        PlayerSettings user = this.playerSettingsRepository.get((OfflinePlayer)player);
        return user.getVanishType() != VanishType.NONE;
    }
}

