/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.vanish;

import java.util.stream.Stream;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.vanish.VanishConfiguration;
import net.shortninja.staffplus.core.domain.staff.vanish.VanishStrategy;
import net.shortninja.staffplusplus.session.SessionManager;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.vanish.VanishType;

@IocBean
@IocMultiProvider(value={VanishStrategy.class})
public class ListVanishStrategy
implements VanishStrategy {
    private final VanishConfiguration vanishConfiguration;
    private final IProtocolService protocolService;
    private final PermissionHandler permission;
    private final SessionManager sessionManager;
    private final PlayerManager playerManager;

    public ListVanishStrategy(VanishConfiguration vanishConfiguration, IProtocolService protocolService, PermissionHandler permission, SessionManager sessionManager, PlayerManager playerManager) {
        this.vanishConfiguration = vanishConfiguration;
        this.protocolService = protocolService;
        this.permission = permission;
        this.sessionManager = sessionManager;
        this.playerManager = playerManager;
    }

    @Override
    public void vanish(SppPlayer player) {
        if (this.vanishConfiguration.vanishTabList) {
            this.protocolService.getVersionProtocol().listVanish(player.getPlayer(), true);
        }
    }

    @Override
    public void unvanish(SppPlayer player) {
        this.protocolService.getVersionProtocol().listVanish(player.getPlayer(), false);
    }

    @Override
    public void updateVanish(SppPlayer player) {
        if (!this.permission.has(player.getPlayer(), this.vanishConfiguration.permissionSeeVanished)) {
            this.sessionManager.getAll().stream().filter(s -> s.getVanishType() == VanishType.LIST).map(s -> this.playerManager.getOnlinePlayer(s.getUuid())).flatMap(optional -> optional.map(Stream::of).orElseGet(Stream::empty)).map(SppPlayer::getPlayer).forEach(p -> this.protocolService.getVersionProtocol().listVanish(p.getPlayer(), true));
        }
    }

    @Override
    public VanishType getVanishType() {
        return VanishType.LIST;
    }
}

