/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.tracing;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.domain.staff.tracing.ChatTraceWriter;
import net.shortninja.staffplus.core.domain.staff.tracing.FileTraceWriter;
import net.shortninja.staffplus.core.domain.staff.tracing.config.TraceConfiguration;
import net.shortninja.staffplusplus.trace.TraceOutputChannel;
import net.shortninja.staffplusplus.trace.TraceWriter;

@IocBean
public class TraceWriterFactory {
    private final Messages messages;
    private final TraceConfiguration traceConfiguration;

    public TraceWriterFactory(Messages messages, TraceConfiguration traceConfiguration) {
        this.messages = messages;
        this.traceConfiguration = traceConfiguration;
    }

    public List<TraceWriter> buildTraceWriters(UUID tracerUuid, UUID tracedUuid) {
        List<TraceOutputChannel> outputChannels = this.traceConfiguration.getOutputChannels();
        ArrayList<TraceWriter> traceWriters = new ArrayList<TraceWriter>();
        if (outputChannels.contains((Object)TraceOutputChannel.CHAT)) {
            traceWriters.add(new ChatTraceWriter(tracerUuid, this.messages));
        }
        if (outputChannels.contains((Object)TraceOutputChannel.FILE)) {
            traceWriters.add(new FileTraceWriter(tracedUuid));
        }
        return traceWriters;
    }
}

