/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.tracing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.tracing.Trace;
import net.shortninja.staffplus.core.domain.staff.tracing.TraceType;
import net.shortninja.staffplus.core.domain.staff.tracing.TraceWriterFactory;
import net.shortninja.staffplus.core.domain.staff.tracing.config.TraceConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import net.shortninja.staffplusplus.trace.ITrace;
import net.shortninja.staffplusplus.trace.StartTraceEvent;
import net.shortninja.staffplusplus.trace.StopTraceEvent;
import net.shortninja.staffplusplus.trace.TraceWriter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
public class TraceService {
    private final Map<UUID, Trace> tracedPlayers = new HashMap<UUID, Trace>();
    private final TraceWriterFactory traceWriterFactory;
    private final TraceConfiguration traceConfiguration;

    public TraceService(TraceWriterFactory traceWriterFactory, TraceConfiguration traceConfiguration) {
        this.traceWriterFactory = traceWriterFactory;
        this.traceConfiguration = traceConfiguration;
    }

    public void startTrace(CommandSender tracer, SppPlayer traced) {
        UUID tracerUuid;
        UUID uUID = tracerUuid = tracer instanceof Player ? ((Player)tracer).getUniqueId() : Constants.CONSOLE_UUID;
        if (this.tracedPlayers.containsKey(tracerUuid)) {
            throw new BusinessException("&CCannot start a trace. You are already tracing a player");
        }
        List<TraceWriter> traceWriters = this.traceWriterFactory.buildTraceWriters(tracerUuid, traced.getId());
        Trace trace = new Trace(traced.getPlayer(), tracerUuid, traceWriters);
        this.tracedPlayers.put(tracerUuid, trace);
        BukkitUtils.sendEvent(new StartTraceEvent(trace));
    }

    public void stopTrace(CommandSender tracer) {
        UUID tracerUuid = tracer instanceof Player ? ((Player)tracer).getUniqueId() : Constants.CONSOLE_UUID;
        this.stopTrace(tracerUuid);
    }

    public void stopTrace(UUID tracerUuid) {
        if (!this.tracedPlayers.containsKey(tracerUuid)) {
            throw new BusinessException("&CYou are currently not tracing anyone");
        }
        Trace trace = this.tracedPlayers.get(tracerUuid);
        trace.stopTrace();
        this.tracedPlayers.remove(tracerUuid);
        BukkitUtils.sendEvent(new StopTraceEvent(trace));
    }

    public void stopAllTracesForPlayer(UUID tracedUuid) {
        this.tracedPlayers.values().stream().filter(t -> t.getTargetUuid() == tracedUuid).forEach(t -> {
            t.stopTrace();
            BukkitUtils.sendEvent(new StopTraceEvent((ITrace)t));
        });
        this.tracedPlayers.values().removeIf(t -> t.getTargetUuid() == tracedUuid);
    }

    public void sendTraceMessage(UUID tracedUuid, String message) {
        List tracers = this.tracedPlayers.entrySet().stream().filter(e -> ((Trace)e.getValue()).getTargetUuid() == tracedUuid).map(Map.Entry::getKey).collect(Collectors.toList());
        Player traced = Bukkit.getPlayer((UUID)tracedUuid);
        for (UUID tracerUuid : tracers) {
            Player tracer = Bukkit.getPlayer((UUID)tracerUuid);
            if (tracer == null || traced == null) {
                this.stopTrace(tracerUuid);
                continue;
            }
            this.tracedPlayers.get(tracerUuid).writeToTrace(message);
        }
    }

    public void sendTraceMessage(TraceType traceType, UUID tracedUuid, String message) {
        if (!this.traceConfiguration.isTraceTypeEnabled(traceType)) {
            return;
        }
        this.sendTraceMessage(tracedUuid, message);
    }

    public boolean isPlayerTracing(Player player) {
        return this.tracedPlayers.containsKey(player.getUniqueId());
    }

    public List<Player> getTracingPlayers() {
        return this.tracedPlayers.keySet().stream().map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

