/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.tracing;

import java.util.List;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.domain.chat.ChatInterceptor;
import net.shortninja.staffplus.core.domain.staff.tracing.TraceService;
import net.shortninja.staffplus.core.domain.staff.tracing.config.TraceConfiguration;
import net.shortninja.staffplusplus.trace.TraceOutputChannel;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@IocBean(conditionalOnProperty="trace-module.enabled=true")
@IocMultiProvider(value={ChatInterceptor.class})
public class TraceChatInterceptor
implements ChatInterceptor {
    private final TraceService traceService;
    private final Messages messages;
    private final TraceConfiguration traceConfiguration;

    public TraceChatInterceptor(TraceService traceService, Messages messages, TraceConfiguration traceConfiguration) {
        this.traceService = traceService;
        this.messages = messages;
        this.traceConfiguration = traceConfiguration;
    }

    @Override
    public boolean intercept(AsyncPlayerChatEvent event) {
        boolean hasChatChannel = this.traceConfiguration.hasChannel(TraceOutputChannel.CHAT);
        if (this.traceService.isPlayerTracing(event.getPlayer()) && hasChatChannel) {
            this.messages.send((CommandSender)event.getPlayer(), this.messages.chatPrevented, this.messages.prefixGeneral);
            return true;
        }
        if (hasChatChannel) {
            List<Player> allTracers = this.traceService.getTracingPlayers();
            event.getRecipients().removeAll(allTracers);
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 8;
    }
}

