/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.tracing;

import java.util.List;
import java.util.UUID;
import net.shortninja.staffplusplus.trace.ITrace;
import net.shortninja.staffplusplus.trace.TraceWriter;
import org.bukkit.entity.Player;

public class Trace
implements ITrace {
    private final String targetName;
    private final UUID targetUuid;
    private final UUID tracerUuid;
    private final List<TraceWriter> writers;

    public Trace(Player traced, UUID tracerUuid, List<TraceWriter> writers) {
        this.writers = writers;
        this.targetName = traced.getName();
        this.tracerUuid = tracerUuid;
        this.targetUuid = traced.getUniqueId();
    }

    @Override
    public List<TraceWriter> getWriters() {
        return this.writers;
    }

    @Override
    public UUID getTracerUuid() {
        return this.tracerUuid;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public UUID getTargetUuid() {
        return this.targetUuid;
    }

    public void writeToTrace(String message) {
        this.writers.forEach(w -> w.writeToTrace(message));
    }

    public void stopTrace() {
        this.writers.forEach(TraceWriter::stopTrace);
    }
}

