/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.tracing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.UUID;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.common.exceptions.ConfigurationException;
import net.shortninja.staffplusplus.trace.TraceOutputChannel;
import net.shortninja.staffplusplus.trace.TraceWriter;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FileTraceWriter
implements TraceWriter {
    private static final String PATH = StaffPlusPlus.get().getDataFolder() + "/trace/";
    private final BufferedWriter writer;
    private final String fileName;

    public FileTraceWriter(UUID tracedUuid) {
        try {
            Player traced = Bukkit.getPlayer((UUID)tracedUuid);
            assert (traced != null);
            String timeStamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            this.fileName = PATH + "trace_" + traced.getName() + "_" + timeStamp + ".txt";
            File traceFile = new File(this.fileName);
            traceFile.getParentFile().mkdirs();
            if (!traceFile.createNewFile()) {
                throw new ConfigurationException("Could not start writing to File, unable to create trace file");
            }
            this.writer = new BufferedWriter(new FileWriter(this.fileName, true));
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not start writing to File, unable to open trace file", e);
        }
    }

    @Override
    public void writeToTrace(String message) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> {
            try {
                String traceMessage = "[" + LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME) + "] : " + message;
                this.writer.write(traceMessage);
                this.writer.newLine();
            }
            catch (IOException e) {
                throw new ConfigurationException("Could not write to trace file", e);
            }
        });
    }

    @Override
    public void stopTrace() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to end trace", e);
        }
    }

    @Override
    public String getResource() {
        return this.fileName;
    }

    @Override
    public TraceOutputChannel getType() {
        return TraceOutputChannel.FILE;
    }
}

