/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.teleport.gui;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.exceptions.PlayerOfflineException;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.teleport.TeleportService;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.entity.Player;

@GuiController
public class TeleportGuiController {
    private final PlayerManager playerManager;
    private final TeleportService teleportService;

    public TeleportGuiController(PlayerManager playerManager, TeleportService teleportService) {
        this.playerManager = playerManager;
        this.teleportService = teleportService;
    }

    @GuiAction(value="teleport")
    public void teleport(Player player, @GuiParam(value="targetPlayerName") String targetPlayerName) {
        SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        if (!sppPlayer.isOnline()) {
            throw new PlayerOfflineException();
        }
        this.teleportService.teleportToPlayer(player, sppPlayer.getPlayer());
    }

    @GuiAction(value="teleport-here")
    public void teleportHere(Player player, @GuiParam(value="targetPlayerName") String targetPlayerName) {
        SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        if (!sppPlayer.isOnline()) {
            throw new PlayerOfflineException();
        }
        this.teleportService.teleportToPlayer(sppPlayer.getPlayer(), player);
    }
}

