/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.teleport.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.IConfigTransformer;
import net.shortninja.staffplus.core.common.exceptions.ConfigurationException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationsConfigTransformer
implements IConfigTransformer<Map<String, Location>, List<LinkedHashMap<String, String>>> {
    @Override
    public Map<String, Location> mapConfig(List<LinkedHashMap<String, String>> linkedHashMaps) {
        HashMap<String, Location> locations = new HashMap<String, Location>();
        linkedHashMaps.forEach(map -> {
            String name = (String)map.get("name");
            String coordinates = (String)map.get("coordinates");
            String[] points = coordinates.split(";");
            if (points.length < 3) {
                throw new ConfigurationException("Invalid locations configuration. Make sure your location points are in format x;y;z;worldname");
            }
            World world = points.length == 4 ? Bukkit.getWorld((String)points[3]) : (World)Bukkit.getWorlds().get(0);
            Location location = new Location(world, Double.parseDouble(points[0]), Double.parseDouble(points[1]), Double.parseDouble(points[2]));
            locations.put(name, location);
        });
        return locations;
    }
}

