/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.teleport.cmd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.cmd.arguments.ArgumentType;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.teleport.TeleportService;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:teleport-to-player", permissions={"permissions:teleport-to-player"}, description="Teleport yourself to a specific player", usage="[player]", playerRetrievalStrategy=PlayerRetrievalStrategy.BOTH)
@IocBean
@IocMultiProvider(value={SppCommand.class})
public class TeleportToPlayerCmd
extends AbstractCmd {
    private final TeleportService teleportService;
    private final PlayerManager playerManager;

    public TeleportToPlayerCmd(Messages messages, TeleportService teleportService, CommandService commandService, PermissionHandler permissionHandler, PlayerManager playerManager) {
        super(messages, permissionHandler, commandService);
        this.teleportService = teleportService;
        this.playerManager = playerManager;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer targetPlayer, Map<String, String> optionalParameters) {
        if (!(sender instanceof Player)) {
            throw new BusinessException(this.messages.onlyPlayers);
        }
        this.teleportService.teleportToPlayer((Player)sender, targetPlayer);
        return true;
    }

    @Override
    protected List<ArgumentType> getPostExecutionSppArguments() {
        return Arrays.asList(ArgumentType.STRIP, ArgumentType.HEALTH);
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.ofNullable(args[0]);
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 1;
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args, String[] sppArgs) throws IllegalArgumentException {
        if (args.length == 1) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> args[0].isEmpty() || s.contains(args[0])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

