/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.teleport.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.cmd.arguments.ArgumentType;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.teleport.TeleportService;
import net.shortninja.staffplus.core.domain.staff.teleport.config.TeleportConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:teleport-to-location", permissions={"permissions:teleport-to-location"}, description="Teleports the player to predefined locations", usage="[player] [location]", delayable=true, playerRetrievalStrategy=PlayerRetrievalStrategy.ONLINE)
@IocBean
@IocMultiProvider(value={SppCommand.class})
public class TeleportToLocationCmd
extends AbstractCmd {
    private final PermissionHandler permissionHandler;
    private final PlayerManager playerManager;
    private final TeleportService teleportService;
    private final TeleportConfiguration teleportConfiguration;
    @ConfigProperty(value="permissions:teleport-bypass")
    private String permissionTeleportBypass;

    public TeleportToLocationCmd(PermissionHandler permissionHandler, Messages messages, PlayerManager playerManager, TeleportService teleportService, CommandService commandService, TeleportConfiguration teleportConfiguration) {
        super(messages, permissionHandler, commandService);
        this.permissionHandler = permissionHandler;
        this.playerManager = playerManager;
        this.teleportService = teleportService;
        this.teleportConfiguration = teleportConfiguration;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer targetPlayer, Map<String, String> optionalParameters) {
        String locationName = args[1];
        this.teleportService.teleportPlayerToLocation(sender, targetPlayer.getPlayer(), locationName);
        return true;
    }

    @Override
    protected List<ArgumentType> getPostExecutionSppArguments() {
        return Arrays.asList(ArgumentType.STRIP, ArgumentType.HEALTH);
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.ofNullable(args[0]);
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 2;
    }

    @Override
    protected boolean canBypass(Player player) {
        return this.permissionHandler.has(player, this.permissionTeleportBypass);
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args, String[] sppArgs) throws IllegalArgumentException {
        ArrayList suggestions = new ArrayList();
        if (args.length == 1) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> args[0].isEmpty() || s.contains(args[0])).collect(Collectors.toList());
        }
        if (args.length == 2) {
            this.teleportConfiguration.locations.forEach((k, v) -> suggestions.add(k));
            return suggestions.stream().filter(s -> args[1].isEmpty() || s.contains(args[1])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

