/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.teleport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.domain.staff.teleport.config.TeleportConfiguration;
import net.shortninja.staffplus.libs.nbtapi.NBTFile;
import net.shortninja.staffplus.libs.nbtapi.iface.ReadWriteNBTList;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@IocBean
public class TeleportService {
    private static final Map<Player, Deque<Location>> previousLocations = new HashMap<Player, Deque<Location>>();
    private final Options options;
    private final Messages messages;
    private final TeleportConfiguration teleportConfiguration;

    public TeleportService(Options options, Messages messages, TeleportConfiguration teleportConfiguration) {
        this.options = options;
        this.messages = messages;
        this.teleportConfiguration = teleportConfiguration;
    }

    public void teleportPlayerToLocation(CommandSender commandSender, Player targetPlayer, String locationId) {
        if (!this.teleportConfiguration.locations.containsKey(locationId)) {
            throw new BusinessException("&CNo location found with name: " + locationId);
        }
        Location location = this.teleportConfiguration.locations.get(locationId);
        this.addPreviousLocation(targetPlayer);
        targetPlayer.teleport(location);
        this.messages.send(commandSender, "&6" + targetPlayer.getName() + " teleported to " + locationId, this.messages.prefixGeneral);
    }

    public void teleportSelf(Player targetPlayer, Location location) {
        this.addPreviousLocation(targetPlayer);
        targetPlayer.teleport(location);
        this.messages.send((CommandSender)targetPlayer, "&6You have been teleported", this.messages.prefixGeneral);
    }

    public void teleportToPlayer(Player sourcePlayer, Player targetPlayer) {
        Location location = targetPlayer.getLocation();
        location.setWorld(targetPlayer.getWorld());
        this.addPreviousLocation(sourcePlayer);
        sourcePlayer.teleport(location);
    }

    public void teleportToPlayer(Player sourcePlayer, SppPlayer targetPlayer) {
        Location location = targetPlayer.isOnline() ? targetPlayer.getPlayer().getLocation() : this.getLocationOfflinePlayer(targetPlayer);
        this.addPreviousLocation(sourcePlayer);
        sourcePlayer.teleport(location);
    }

    public void teleportPlayerBack(Player player) {
        if (!previousLocations.containsKey(player) || previousLocations.get(player).isEmpty()) {
            throw new BusinessException("&CUnable to teleport player back, no previous locations found");
        }
        Location previousLocation = previousLocations.get(player).pop();
        player.teleport(previousLocation);
    }

    private void addPreviousLocation(Player player) {
        if (!previousLocations.containsKey(player)) {
            previousLocations.put(player, new ArrayDeque());
        }
        previousLocations.get(player).push(player.getLocation());
    }

    private Location getLocationOfflinePlayer(SppPlayer sppPlayer) {
        try {
            String filename = Bukkit.getWorldContainer() + File.separator + this.options.mainWorld + File.separator + "playerdata" + File.separator + sppPlayer.getId() + ".dat";
            NBTFile file = new NBTFile(new File(filename));
            long uuidLeast = file.getLong("WorldUUIDLeast");
            long uuidMost = file.getLong("WorldUUIDMost");
            ReadWriteNBTList positions = file.getDoubleList("Pos");
            World world = Bukkit.getWorlds().stream().filter(w -> w.getUID().getLeastSignificantBits() == uuidLeast && w.getUID().getMostSignificantBits() == uuidMost).findFirst().orElseThrow(() -> new BusinessException("Could not load location of offline player: [" + sppPlayer.getUsername() + "]"));
            return new Location(world, ((Double)positions.get(0)).doubleValue(), ((Double)positions.get(1)).doubleValue(), ((Double)positions.get(2)).doubleValue());
        }
        catch (IOException e) {
            throw new BusinessException("Could not load location of offline player: [" + sppPlayer.getUsername() + "]");
        }
    }
}

