/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.staffchat.cmd;

import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.staffchat.StaffChatChannelConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StaffChatSoundChannelCmd
extends AbstractCmd {
    private final PlayerSettingsRepository playerSettingsRepository;
    private final StaffChatChannelConfiguration channelConfiguration;
    private final BukkitUtils bukkitUtils;

    public StaffChatSoundChannelCmd(Messages messages, CommandService commandService, PlayerSettingsRepository playerSettingsRepository, StaffChatChannelConfiguration channelConfiguration, PermissionHandler permissionHandler, BukkitUtils bukkitUtils) {
        super(channelConfiguration.getCommand() + "-sound", messages, permissionHandler, commandService);
        this.playerSettingsRepository = playerSettingsRepository;
        this.channelConfiguration = channelConfiguration;
        this.bukkitUtils = bukkitUtils;
        this.setDescription("Toggles notification sound for channel.");
        if (channelConfiguration.getPermission().isPresent()) {
            this.setPermission(channelConfiguration.getPermission().get() + ".sound");
        }
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        this.validateIsPlayer(sender);
        PlayerSettings session = this.playerSettingsRepository.get((OfflinePlayer)((Player)sender));
        if (session.isStaffChatSoundEnabled(this.channelConfiguration.getName())) {
            this.messages.send(sender, this.messages.staffChatSoundDisabled, this.channelConfiguration.getPrefix());
        } else {
            this.messages.send(sender, this.messages.staffChatSoundEnabled, this.channelConfiguration.getPrefix());
        }
        this.updateSession(sender);
        return true;
    }

    private void updateSession(CommandSender sender) {
        this.bukkitUtils.runTaskAsync(sender, () -> {
            PlayerSettings session = this.playerSettingsRepository.get((OfflinePlayer)sender);
            session.setStaffChatNotificationSound(this.channelConfiguration.getName(), !session.isStaffChatSoundEnabled(this.channelConfiguration.getName()));
            this.playerSettingsRepository.save(session);
        });
    }

    @Override
    protected PlayerRetrievalStrategy getPlayerRetrievalStrategy() {
        return PlayerRetrievalStrategy.NONE;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 0;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.empty();
    }
}

