/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.staffchat.cmd;

import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.staffchat.StaffChatChannelConfiguration;
import net.shortninja.staffplus.core.domain.staff.staffchat.StaffChatServiceImpl;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StaffChatChannelCmd
extends AbstractCmd {
    private final OnlineSessionsManager sessionManager;
    private final StaffChatServiceImpl staffChatService;
    private final StaffChatChannelConfiguration channelConfiguration;
    private final BukkitUtils bukkitUtils;

    public StaffChatChannelCmd(Messages messages, OnlineSessionsManager sessionManager, StaffChatServiceImpl staffChatService, CommandService commandService, StaffChatChannelConfiguration channelConfiguration, PermissionHandler permissionHandler, BukkitUtils bukkitUtils) {
        super(channelConfiguration.getCommand(), messages, permissionHandler, commandService);
        this.sessionManager = sessionManager;
        this.staffChatService = staffChatService;
        this.channelConfiguration = channelConfiguration;
        this.bukkitUtils = bukkitUtils;
        this.setDescription("Sends a message or toggles staff chat for channel:" + channelConfiguration.getName());
        this.setUsage("{message}");
        channelConfiguration.getPermission().ifPresent(this::setPermission);
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        if (args.length > 0) {
            this.staffChatService.sendMessage(sender, this.channelConfiguration.getName(), JavaUtils.compileWords(args, 0));
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Please provide a message");
                return false;
            }
            this.bukkitUtils.runTaskAsync(sender, () -> {
                PlayerSession session = this.sessionManager.get((Player)sender);
                if (session.getActiveStaffChatChannel().isPresent() && session.getActiveStaffChatChannel().get().equalsIgnoreCase(this.channelConfiguration.getName())) {
                    this.messages.send(sender, this.messages.staffChatStatus.replace("%status%", this.messages.disabled), this.channelConfiguration.getPrefix());
                    session.setActiveStaffChatChannel(null);
                } else {
                    this.messages.send(sender, this.messages.staffChatStatus.replace("%status%", this.messages.enabled), this.channelConfiguration.getPrefix());
                    session.setActiveStaffChatChannel(this.channelConfiguration.getName());
                }
            });
        }
        return true;
    }

    @Override
    protected PlayerRetrievalStrategy getPlayerRetrievalStrategy() {
        return PlayerRetrievalStrategy.NONE;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 0;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.empty();
    }
}

