/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.staffchat;

import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.exceptions.ConfigurationException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.staffchat.StaffChatChannelConfiguration;
import net.shortninja.staffplus.core.domain.staff.staffchat.StaffChatMessageFormatter;
import net.shortninja.staffplus.core.domain.staff.staffchat.bungee.StaffChatBungeeMessage;
import net.shortninja.staffplus.core.domain.staff.staffchat.bungee.StaffChatReceivedBungeeEvent;
import net.shortninja.staffplus.core.domain.staff.staffchat.config.StaffChatConfiguration;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.staffmode.chat.StaffChatEvent;
import net.shortninja.staffplusplus.staffmode.chat.StaffChatService;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class StaffChatServiceImpl
implements StaffChatService,
Listener {
    private static final String STAFFCHAT = "staffchat";
    private final Messages messages;
    private final Options options;
    private final PermissionHandler permissionHandler;
    private final StaffChatMessageFormatter staffChatMessageFormatter;
    private final StaffChatConfiguration staffChatConfiguration;
    private final PlayerSettingsRepository playerSettingsRepository;

    public StaffChatServiceImpl(Messages messages, Options options, PermissionHandler permissionHandler, StaffChatMessageFormatter staffChatMessageFormatter, StaffChatConfiguration staffChatConfiguration, PlayerSettingsRepository playerSettingsRepository) {
        this.messages = messages;
        this.options = options;
        this.permissionHandler = permissionHandler;
        this.staffChatMessageFormatter = staffChatMessageFormatter;
        this.staffChatConfiguration = staffChatConfiguration;
        this.playerSettingsRepository = playerSettingsRepository;
    }

    @EventHandler
    public void handleBungeeMessage(StaffChatReceivedBungeeEvent event) {
        StaffChatBungeeMessage staffChatMessage = event.getStaffChatMessage();
        StaffChatChannelConfiguration channel = this.getChannel(staffChatMessage.getChannel());
        String formattedMessage = this.staffChatMessageFormatter.formatMessage(staffChatMessage.getPlayerName(), channel, staffChatMessage.getMessage(), event.getStaffChatMessage().getServerName());
        this.sendMessageToStaff(channel, formattedMessage, null);
    }

    public void sendMessage(CommandSender sender, String channelName, String message) {
        StaffChatChannelConfiguration channel = this.getChannel(channelName);
        String formattedMessage = this.staffChatMessageFormatter.formatMessage(sender, channel, message, this.options.serverName);
        this.sendMessageToStaff(channel, formattedMessage, sender);
        if (sender instanceof Player) {
            BukkitUtils.sendEvent(new StaffChatEvent((Player)sender, this.options.serverName, message, channelName));
        }
    }

    private StaffChatChannelConfiguration getChannel(String channelName) {
        return this.staffChatConfiguration.getChannelConfigurations().stream().filter(c -> c.getName().equalsIgnoreCase(channelName)).findFirst().orElseThrow(() -> new ConfigurationException("No channel with name [" + channelName + "] configured"));
    }

    public boolean hasHandle(String channelName, String message) {
        StaffChatChannelConfiguration channel = this.getChannel(channelName);
        return channel.getHandle().isPresent() && StringUtils.isNotEmpty(channel.getHandle().get()) && message.startsWith(channel.getHandle().get());
    }

    @Override
    @Deprecated
    public void sendMessage(String message) {
        StaffChatChannelConfiguration channel = this.getChannel(STAFFCHAT);
        this.sendMessageToStaff(channel, message, null);
    }

    @Override
    public void sendMessage(String channelName, String message) {
        StaffChatChannelConfiguration channel = this.getChannel(channelName);
        this.sendMessageToStaff(channel, message, null);
    }

    private void sendMessageToStaff(StaffChatChannelConfiguration channel, String formattedMessage, CommandSender sender) {
        Bukkit.getOnlinePlayers().stream().filter(p -> !this.playerSettingsRepository.get((OfflinePlayer)p).isStaffChatMuted(channel.getName())).filter(player -> this.permissionHandler.has((Player)player, (String)channel.getPermission().orElse(null))).forEach(player -> {
            this.messages.send((CommandSender)player, formattedMessage, channel.getPrefix());
            this.sendNotificationSound(channel, sender, (Player)player);
        });
        this.messages.send((CommandSender)Bukkit.getConsoleSender(), formattedMessage, channel.getPrefix());
    }

    private void sendNotificationSound(StaffChatChannelConfiguration channel, CommandSender sender, Player player) {
        PlayerSettings playerSettings = this.playerSettingsRepository.get((OfflinePlayer)player);
        if (sender instanceof Player && !((Player)sender).getUniqueId().equals(player.getUniqueId()) && playerSettings.isStaffChatSoundEnabled(channel.getName())) {
            channel.getNotificationSound().ifPresent(s -> s.play(player));
        }
    }
}

