/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.staffchat;

import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.chat.ChatInterceptor;
import net.shortninja.staffplus.core.domain.staff.staffchat.StaffChatChannelConfiguration;
import net.shortninja.staffplus.core.domain.staff.staffchat.StaffChatServiceImpl;
import net.shortninja.staffplus.core.domain.staff.staffchat.config.StaffChatConfiguration;
import org.bukkit.command.CommandSender;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class StaffChatChatInterceptor
implements ChatInterceptor {
    private final StaffChatServiceImpl staffChatService;
    private final PermissionHandler permission;
    private final OnlineSessionsManager sessionManager;
    private final StaffChatChannelConfiguration channelConfiguration;
    private final StaffChatConfiguration staffChatConfiguration;

    public StaffChatChatInterceptor(StaffChatServiceImpl staffChatService, PermissionHandler permission, OnlineSessionsManager sessionManager, StaffChatChannelConfiguration channelConfiguration, StaffChatConfiguration staffChatConfiguration) {
        this.staffChatService = staffChatService;
        this.permission = permission;
        this.sessionManager = sessionManager;
        this.channelConfiguration = channelConfiguration;
        this.staffChatConfiguration = staffChatConfiguration;
    }

    @Override
    public boolean intercept(AsyncPlayerChatEvent event) {
        if (!this.staffChatConfiguration.isEnabled()) {
            return false;
        }
        PlayerSession session = this.sessionManager.get(event.getPlayer());
        if (session.getActiveStaffChatChannel().isPresent() && session.getActiveStaffChatChannel().get().equalsIgnoreCase(this.channelConfiguration.getName())) {
            this.staffChatService.sendMessage((CommandSender)event.getPlayer(), session.getActiveStaffChatChannel().get(), event.getMessage());
            return true;
        }
        if (this.staffChatService.hasHandle(this.channelConfiguration.getName(), event.getMessage()) && this.permission.has(event.getPlayer(), (String)this.channelConfiguration.getPermission().orElse(null))) {
            this.staffChatService.sendMessage((CommandSender)event.getPlayer(), this.channelConfiguration.getName(), event.getMessage().substring(this.channelConfiguration.getHandle().orElse("").length()));
            return true;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 6;
    }
}

