/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.revive;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModeService;
import net.shortninja.staffplus.core.domain.staff.revive.InventoryVault;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@IocBean
public class ReviveHandler {
    private static final Map<UUID, InventoryVault> savedInventories = new HashMap<UUID, InventoryVault>();
    private final Messages messages;

    public ReviveHandler(Messages messages) {
        this.messages = messages;
    }

    public boolean hasSavedInventory(UUID uuid) {
        return savedInventories.containsKey(uuid);
    }

    public void cacheInventory(Player player) {
        UUID uuid = player.getUniqueId();
        InventoryVault inventoryVault = new InventoryVault(uuid, StaffModeService.getContents(player), player.getInventory().getArmorContents(), player.getInventory().getExtraContents());
        savedInventories.put(uuid, inventoryVault);
    }

    public void restoreInventory(Player player) {
        UUID uuid = player.getUniqueId();
        InventoryVault inventoryVault = savedInventories.get(uuid);
        JavaUtils.clearInventory(player);
        this.getItems(player, inventoryVault);
        player.getInventory().setArmorContents(inventoryVault.getArmor());
        player.getInventory().setExtraContents(inventoryVault.getOffHand());
        this.messages.send((CommandSender)player, this.messages.revivedUser, this.messages.prefixGeneral);
        savedInventories.remove(uuid);
    }

    private void getItems(Player p, InventoryVault inventoryVault) {
        ItemStack[] items = inventoryVault.getInventory();
        for (int i = 0; i < items.length; ++i) {
            p.getInventory().setItem(i, items[i]);
        }
    }
}

