/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.queue.listeners;

import java.util.UUID;
import net.shortninja.staffplus.core.application.queue.QueueMessageListener;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.domain.staff.reporting.ManageReportService;
import net.shortninja.staffplus.core.domain.staff.reporting.queue.dto.ReportClosedQueueMessage;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Bukkit;

@IocBean
@IocMultiProvider(value={QueueMessageListener.class})
public class ReportClosedListener
implements QueueMessageListener<ReportClosedQueueMessage> {
    private final ManageReportService reportService;

    public ReportClosedListener(ManageReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public String handleMessage(ReportClosedQueueMessage message) {
        SppPlayer sppPlayer = new SppPlayer(message.getPlayerUuid(), message.getPlayerName(), Bukkit.getOfflinePlayer((UUID)message.getPlayerUuid()));
        this.reportService.closeReport(sppPlayer, message.getCloseReportRequest());
        return "Report with ID " + message.getCloseReportRequest().getReportId() + " has been closed";
    }

    @Override
    public String getType() {
        return "report/close";
    }

    @Override
    public Class getMessageClass() {
        return ReportClosedQueueMessage.class;
    }
}

