/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.gui.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.exceptions.NoPermissionException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.staff.reporting.ManageReportService;
import net.shortninja.staffplus.core.domain.staff.reporting.Report;
import net.shortninja.staffplus.core.domain.staff.reporting.ReportService;
import net.shortninja.staffplusplus.reports.IReport;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;

@Command(command="commands:reports.manage.cli", permissions={"permissions:reports.manage.view"}, description="Manage Reports.", usage="[get|clear] [player]", playerRetrievalStrategy=PlayerRetrievalStrategy.BOTH)
@IocBean(conditionalOnProperty="reports-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class ReportsCmd
extends AbstractCmd {
    @ConfigProperty(value="permissions:reports.manage.view")
    public String permissionView;
    @ConfigProperty(value="permissions:reports.manage.view")
    public String permissionDelete;
    private final PermissionHandler permissionHandler;
    private final ReportService reportService;
    private final ManageReportService manageReportService;

    public ReportsCmd(PermissionHandler permissionHandler, Messages messages, ReportService reportService, ManageReportService manageReportService, CommandService commandService) {
        super(messages, permissionHandler, commandService);
        this.permissionHandler = permissionHandler;
        this.reportService = reportService;
        this.manageReportService = manageReportService;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        String argument = args[0];
        if (argument.equalsIgnoreCase("get")) {
            if (!this.permissionHandler.has(sender, this.permissionView)) {
                throw new NoPermissionException();
            }
            this.listReports(sender, player);
            return true;
        }
        if (argument.equalsIgnoreCase("clear")) {
            if (!this.permissionHandler.has(sender, this.permissionDelete)) {
                throw new NoPermissionException();
            }
            this.clearReports(sender, player);
            return true;
        }
        this.sendHelp(sender);
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 2;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.of(args[1]);
    }

    private void listReports(CommandSender sender, SppPlayer player) {
        List<Report> reports = this.reportService.getReported(player, 0, 40);
        for (String message2 : this.messages.reportsListStart) {
            this.messages.send(sender, message2.replace("%longline%", this.messages.LONG_LINE).replace("%target%", player.getUsername()).replace("%reports%", Integer.toString(reports.size())), message2.contains("%longline%") ? "" : this.messages.prefixReports);
        }
        for (int i = 0; i < reports.size(); ++i) {
            IReport report = reports.get(i);
            this.messages.send(sender, this.messages.reportsListEntry.replace("%count%", Integer.toString(i + 1)).replace("%reason%", report.getReason()).replace("%reporter%", report.getReporterName()), this.messages.prefixReports);
        }
        this.messages.reportsListEnd.forEach(message -> this.messages.send(sender, message.replace("%longline%", this.messages.LONG_LINE).replace("%target%", player.getUsername()).replace("%reports%", Integer.toString(reports.size())), message.contains("%longline%") ? "" : this.messages.prefixReports));
    }

    private void clearReports(CommandSender sender, SppPlayer player) {
        this.manageReportService.clearReports(player);
        this.messages.send(sender, this.messages.reportsCleared.replace("%culprit%", player.getUsername()), this.messages.prefixReports);
    }

    private void sendHelp(CommandSender sender) {
        this.messages.send(sender, "&7" + this.messages.LONG_LINE, "");
        this.messages.send(sender, "&b/" + this.getName() + " &7" + this.getUsage(), this.messages.prefixReports);
        this.messages.send(sender, "&b/" + this.getName() + " get &7[player]", this.messages.prefixReports);
        this.messages.send(sender, "&b/" + this.getName() + " clear &7[player]", this.messages.prefixReports);
        this.messages.send(sender, "&7" + this.messages.LONG_LINE, "");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1 && !args[0].equals("get") && !args[0].equals("clear")) {
            suggestions.add("get");
            suggestions.add("clear");
            return suggestions;
        }
        return Collections.emptyList();
    }
}

