/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.gui.cmd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.SppInteractorBuilder;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.reporting.ReportService;
import net.shortninja.staffplus.core.domain.staff.reporting.config.CulpritFilterPredicate;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportConfiguration;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportReasonConfiguration;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportTypeConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(command="commands:reportPlayer", permissions={"permissions:report"}, description="Sends a report with the given player and reason.", usage="[player] [reason]", playerRetrievalStrategy=PlayerRetrievalStrategy.BOTH)
@IocBean(conditionalOnProperty="reports-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class ReportPlayerCmd
extends AbstractCmd {
    private static final CulpritFilterPredicate culpritFilterPredicate = new CulpritFilterPredicate(true);
    private final List<ReportTypeConfiguration> reportTypeConfigurations;
    private final List<ReportReasonConfiguration> reportReasonConfigurations;
    private final ReportService reportService;
    private final PlayerManager playerManager;
    private final BukkitUtils bukkitUtils;
    private final ReportConfiguration reportConfiguration;
    private final GuiActionService guiActionService;

    public ReportPlayerCmd(Messages messages, ReportService reportService, PlayerManager playerManager, CommandService commandService, PermissionHandler permissionHandler, BukkitUtils bukkitUtils, ReportConfiguration reportConfiguration, GuiActionService guiActionService) {
        super(messages, permissionHandler, commandService);
        this.reportService = reportService;
        this.playerManager = playerManager;
        this.reportConfiguration = reportConfiguration;
        this.guiActionService = guiActionService;
        this.reportTypeConfigurations = this.reportConfiguration.getReportTypeConfigurations(culpritFilterPredicate);
        this.reportReasonConfigurations = this.reportConfiguration.getReportReasonConfigurations(culpritFilterPredicate);
        this.bukkitUtils = bukkitUtils;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        String reason;
        String string = reason = this.reportConfiguration.isFixedReasonCulprit() ? null : JavaUtils.compileWords(args, 1);
        if (this.reportTypeConfigurations.isEmpty() && this.reportReasonConfigurations.isEmpty()) {
            this.bukkitUtils.runTaskAsync(sender, () -> this.reportService.sendReport(SppInteractorBuilder.fromSender(sender), player, reason));
            return true;
        }
        if (!this.reportTypeConfigurations.isEmpty()) {
            this.guiActionService.executeAction((Player)sender, GuiActionBuilder.builder().action("reports/view/type-select").param("reason", reason).param("culprit", player.getUsername()).build());
            return true;
        }
        this.guiActionService.executeAction((Player)sender, GuiActionBuilder.builder().action("reports/view/reason-select").param("culprit", player.getUsername()).build());
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        if (this.reportReasonConfigurations.isEmpty()) {
            return 2;
        }
        return 1;
    }

    @Override
    protected boolean isAuthenticationRequired() {
        return false;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.of(args[0]);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        if (args.length == 1) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> args[0].isEmpty() || s.contains(args[0])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

