/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.gui.chat;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.dto.ReportBungeeDto;
import net.shortninja.staffplusplus.reports.IReport;
import net.shortninja.staffplusplus.reports.ReportStatus;

@IocBean
public class ReportMessageUtil {
    private final Messages messages;

    public ReportMessageUtil(Messages messages) {
        this.messages = messages;
    }

    public String replaceReportPlaceholders(String message, IReport report) {
        return this.replaceReportPlaceholders(report.getId(), message, report.getStaffName(), report.getReporterName(), report.getCulpritName(), report.getReason(), report.getReportStatus(), report.getCloseReason());
    }

    public String replaceReportPlaceholders(String message, ReportBungeeDto report) {
        return this.replaceReportPlaceholders(report.getId(), message, report.getStaffName(), report.getReporterName(), report.getCulpritName(), report.getReason(), report.getReportStatus(), report.getCloseReason());
    }

    public String replaceReportPlaceholders(String message, String staff, IReport report) {
        return this.replaceReportPlaceholders(report.getId(), message, staff, report.getReporterName(), report.getCulpritName(), report.getReason(), report.getReportStatus(), report.getCloseReason());
    }

    public String replaceReportPlaceholders(String message, String staff, ReportBungeeDto report) {
        return this.replaceReportPlaceholders(report.getId(), message, staff, report.getReporterName(), report.getCulpritName(), report.getReason(), report.getReportStatus(), report.getCloseReason());
    }

    public String replaceReportPlaceholders(int reportId, String message, String staff, String reporterName, String culpritName, String reason, ReportStatus reportStatus, String closeReason) {
        String result = message;
        result = result.replace("%reportId%", String.valueOf(reportId));
        if (staff != null) {
            result = result.replace("%staff%", staff);
        }
        if (reporterName != null) {
            result = result.replace("%reporter%", reporterName);
        }
        if (culpritName != null) {
            result = result.replace("%culprit%", culpritName);
        }
        if (culpritName == null) {
            result = result.replace("%culprit%", "Unknown");
        }
        if (reason != null) {
            result = result.replace("%reason%", reason);
        }
        if (reportStatus != null) {
            result = result.replace("%status%", this.translateStatus(reportStatus));
        }
        if (closeReason != null) {
            result = result.replace("%close_reason%", closeReason);
        }
        return result;
    }

    public String translateStatus(ReportStatus reportStatus) {
        switch (reportStatus) {
            case OPEN: {
                return this.messages.reportOpenStatus;
            }
            case IN_PROGRESS: {
                return this.messages.reportInProgressStatus;
            }
            case RESOLVED: {
                return this.messages.reportResolvedStatus;
            }
            case REJECTED: {
                return this.messages.reportRejectedStatus;
            }
        }
        return "Unknown";
    }
}

