/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.gui.chat;

import be.garagepoort.staffplusplus.craftbukkit.common.json.rayzr.JSONMessage;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.JsonSenderService;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.dto.ReportBungeeDto;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.dto.ReportDeletedBungeeDto;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.dto.ReportReopenedBungeeDto;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.events.ReportAcceptedBungeeEvent;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.events.ReportClosedBungeeEvent;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.events.ReportCreatedBungeeEvent;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.events.ReportDeletedBungeeEvent;
import net.shortninja.staffplus.core.domain.staff.reporting.bungee.events.ReportReopenedBungeeEvent;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportConfiguration;
import net.shortninja.staffplus.core.domain.staff.reporting.gui.chat.ReportMessageUtil;
import net.shortninja.staffplusplus.reports.AcceptReportEvent;
import net.shortninja.staffplusplus.reports.CreateReportEvent;
import net.shortninja.staffplusplus.reports.DeleteReportEvent;
import net.shortninja.staffplusplus.reports.IReport;
import net.shortninja.staffplusplus.reports.RejectReportEvent;
import net.shortninja.staffplusplus.reports.ReopenReportEvent;
import net.shortninja.staffplusplus.reports.ReportStatus;
import net.shortninja.staffplusplus.reports.ResolveReportEvent;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class ReportChatNotifier
implements Listener {
    @ConfigProperty(value="permissions:report-update-notifications")
    private String permissionReportUpdateNotifications;
    private final Messages messages;
    private final PlayerManager playerManager;
    private final PermissionHandler permission;
    private final ReportMessageUtil reportMessageUtil;
    private final ReportConfiguration reportConfiguration;
    private final JsonSenderService jsonSenderService;

    public ReportChatNotifier(Messages messages, PlayerManager playerManager, PermissionHandler permission, ReportMessageUtil reportMessageUtil, ReportConfiguration reportConfiguration, JsonSenderService jsonSenderService) {
        this.messages = messages;
        this.playerManager = playerManager;
        this.permission = permission;
        this.reportMessageUtil = reportMessageUtil;
        this.reportConfiguration = reportConfiguration;
        this.jsonSenderService = jsonSenderService;
    }

    @EventHandler
    public void handleReportCreation(CreateReportEvent event) {
        IReport report = event.getReport();
        String message = this.reportMessageUtil.replaceReportPlaceholders(report.getCulpritUuid() == null ? this.messages.reporterReportCreated : this.messages.reporterReportPlayerCreated, report);
        this.playerManager.getOnlinePlayer(report.getReporterUuid()).ifPresent(sppPlayer -> this.messages.send((CommandSender)sppPlayer.getPlayer(), message, this.messages.prefixReports));
        String notificationMessage = report.getCulpritUuid() == null ? this.messages.reportCreatedNotification : this.messages.reportCulpritCreatedNotification;
        this.sendStaffNotification(report, notificationMessage);
        this.reportConfiguration.getSound().ifPresent(s -> s.playForGroup(this.permissionReportUpdateNotifications));
    }

    @EventHandler
    public void handleReportCreationBungee(ReportCreatedBungeeEvent event) {
        ReportBungeeDto report = event.getReport();
        String notificationMessage = this.reportMessageUtil.replaceReportPlaceholders(report.getCulpritUuid() == null ? this.messages.reportCreatedNotification : this.messages.reportCulpritCreatedNotification, report);
        this.sendStaffNotification(report, notificationMessage);
        this.reportConfiguration.getSound().ifPresent(s -> s.playForGroup(this.permissionReportUpdateNotifications));
    }

    @EventHandler
    public void handleReportDeletion(DeleteReportEvent event) {
        IReport report = event.getReport();
        String message = this.reportMessageUtil.replaceReportPlaceholders(this.messages.reportDeletedNotification, event.getDeletedByName(), report);
        this.messages.sendGroupMessage(message, this.permissionReportUpdateNotifications, this.messages.prefixReports);
    }

    @EventHandler
    public void handleReportDeletionBungee(ReportDeletedBungeeEvent event) {
        ReportDeletedBungeeDto report = event.getReportDeleted();
        String message = this.reportMessageUtil.replaceReportPlaceholders(this.messages.reportDeletedNotification, report.getDeletedByName(), report);
        this.messages.sendGroupMessage(message, this.permissionReportUpdateNotifications, this.messages.prefixReports);
    }

    @EventHandler
    public void handleReportAccepted(AcceptReportEvent event) {
        IReport report = event.getReport();
        this.sendStaffNotification(report, this.messages.reportAcceptedNotification);
        this.notifyReporter(report.getReporterUuid(), this.reportMessageUtil.replaceReportPlaceholders(this.messages.reporterReportAccepted, report), ReportStatus.IN_PROGRESS);
    }

    @EventHandler
    public void handleReportAcceptedBungee(ReportAcceptedBungeeEvent event) {
        ReportBungeeDto report = event.getReport();
        this.sendStaffNotification(report, this.messages.reportAcceptedNotification);
        this.notifyReporter(report.getReporterUuid(), this.reportMessageUtil.replaceReportPlaceholders(this.messages.reporterReportAccepted, report), ReportStatus.IN_PROGRESS);
    }

    @EventHandler
    public void handleReportRejected(RejectReportEvent event) {
        IReport report = event.getReport();
        this.sendStaffNotification(report, this.messages.reportClosedNotification);
        this.notifyReporter(report.getReporterUuid(), this.reportMessageUtil.replaceReportPlaceholders(this.messages.reporterReportRejected, report), ReportStatus.REJECTED);
    }

    @EventHandler
    public void handleReportResolved(ResolveReportEvent event) {
        IReport report = event.getReport();
        this.sendStaffNotification(report, this.messages.reportClosedNotification);
        this.notifyReporter(report.getReporterUuid(), this.reportMessageUtil.replaceReportPlaceholders(this.messages.reporterReportResolved, report), ReportStatus.RESOLVED);
    }

    @EventHandler
    public void handleReportClosedBungee(ReportClosedBungeeEvent event) {
        ReportBungeeDto report = event.getReport();
        ReportStatus reportStatus = report.getReportStatus();
        this.sendStaffNotification(report, this.messages.reportClosedNotification);
        String message = reportStatus == ReportStatus.REJECTED ? this.messages.reporterReportRejected : this.messages.reporterReportResolved;
        this.notifyReporter(report.getReporterUuid(), this.reportMessageUtil.replaceReportPlaceholders(message, report), reportStatus);
    }

    @EventHandler
    public void handleReportReopened(ReopenReportEvent event) {
        IReport report = event.getReport();
        String message = this.reportMessageUtil.replaceReportPlaceholders(this.messages.reportReopenedNotification, event.getReopenedByName(), report);
        this.messages.sendGroupMessage(message, this.permissionReportUpdateNotifications, this.messages.prefixReports);
    }

    @EventHandler
    public void handleReportReopenedBungee(ReportReopenedBungeeEvent event) {
        ReportReopenedBungeeDto report = event.getReopenedBungeeDto();
        String message = this.reportMessageUtil.replaceReportPlaceholders(this.messages.reportReopenedNotification, report.getReopenByName(), report);
        this.messages.sendGroupMessage(message, this.permissionReportUpdateNotifications, this.messages.prefixReports);
    }

    private void sendStaffNotification(IReport report, String reportClosedNotification) {
        this.messages.sendGroupMessage(this.reportMessageUtil.replaceReportPlaceholders(reportClosedNotification, report), this.permissionReportUpdateNotifications, this.messages.prefixReports);
    }

    private void sendStaffNotification(ReportBungeeDto report, String reportClosedNotification) {
        this.messages.sendGroupMessage(this.reportMessageUtil.replaceReportPlaceholders(reportClosedNotification, report), this.permissionReportUpdateNotifications, this.messages.prefixReports);
    }

    private void notifyReporter(UUID reporterUuid, String title, ReportStatus reportStatus) {
        if (!this.reportConfiguration.getReporterNotifyStatuses().contains((Object)reportStatus)) {
            return;
        }
        Optional<SppPlayer> reporter = this.playerManager.getOnlinePlayer(reporterUuid);
        reporter.ifPresent(sppPlayer -> {
            JSONMessage message = JavaUtils.buildClickableMessage(this.messages.prefixReports + " " + title, this.messages.reporterViewReportsButton, this.messages.reporterViewReportsButtonTooltip, this.reportConfiguration.getMyReportsCmd(), this.permission.has(sppPlayer.getPlayer(), this.reportConfiguration.getMyReportsPermission()));
            this.jsonSenderService.send(message, sppPlayer.getPlayer());
        });
    }
}

