/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionReturnType;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParams;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.chatchannels.ChatChannel;
import net.shortninja.staffplus.core.domain.chatchannels.ChatChannelService;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.reporting.CloseReportRequest;
import net.shortninja.staffplus.core.domain.staff.reporting.ManageReportService;
import net.shortninja.staffplus.core.domain.staff.reporting.Report;
import net.shortninja.staffplus.core.domain.staff.reporting.ReportService;
import net.shortninja.staffplus.core.domain.staff.reporting.chatchannels.ReportChatChannelService;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ManageReportConfiguration;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportConfiguration;
import net.shortninja.staffplus.core.domain.staff.reporting.gui.cmd.ReportFiltersMapper;
import net.shortninja.staffplusplus.chatchannels.ChatChannelType;
import net.shortninja.staffplusplus.reports.ReportFilters;
import net.shortninja.staffplusplus.reports.ReportStatus;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class ManageReportsGuiController {
    @ConfigProperty(value="%lang%:reports.resolve-confirmation-question")
    private String resolveConfirmationLines;
    @ConfigProperty(value="%lang%:reports.resolve-cancelled")
    private String resolveCancelled;
    @ConfigProperty(value="%lang%:reports.reject-confirmation-question")
    private String rejectConfirmationLines;
    @ConfigProperty(value="%lang%:reports.reject-cancelled")
    private String rejectCancelled;
    private static final int PAGE_SIZE = 45;
    private static final String CANCEL = "cancel";
    private final PermissionHandler permissionHandler;
    private final ManageReportConfiguration manageReportConfiguration;
    private final ReportService reportService;
    private final BukkitUtils bukkitUtils;
    private final Messages messages;
    private final ManageReportService manageReportService;
    private final OnlineSessionsManager sessionManager;
    private final ReportFiltersMapper reportFiltersMapper;
    private final PlayerManager playerManager;
    private final ChatChannelService chatChannelService;
    private final ReportChatChannelService reportChatChannelService;
    private final ReportConfiguration reportConfiguration;

    public ManageReportsGuiController(PermissionHandler permissionHandler, ManageReportConfiguration manageReportConfiguration, ReportService reportService, BukkitUtils bukkitUtils, Messages messages, ManageReportService manageReportService, OnlineSessionsManager sessionManager, ReportFiltersMapper reportFiltersMapper, PlayerManager playerManager, ChatChannelService chatChannelService, ReportChatChannelService reportChatChannelService, ReportConfiguration reportConfiguration) {
        this.permissionHandler = permissionHandler;
        this.manageReportConfiguration = manageReportConfiguration;
        this.reportService = reportService;
        this.bukkitUtils = bukkitUtils;
        this.messages = messages;
        this.manageReportService = manageReportService;
        this.sessionManager = sessionManager;
        this.reportFiltersMapper = reportFiltersMapper;
        this.playerManager = playerManager;
        this.chatChannelService = chatChannelService;
        this.reportChatChannelService = reportChatChannelService;
        this.reportConfiguration = reportConfiguration;
    }

    @GuiAction(value="manage-reports/view/overview")
    public GuiTemplate manageReportsOverview(Player player) {
        this.permissionHandler.validate((CommandSender)player, this.manageReportConfiguration.permissionView);
        return GuiTemplate.template("gui/reports/manage-reports.ftl", new HashMap<String, Object>());
    }

    @GuiAction(value="manage-reports/view/find-reports")
    public AsyncGui<GuiTemplate> viewFindReports(@GuiParam(value="page", defaultValue="0") int page, @GuiParams Map<String, String> allParams) {
        return AsyncGui.async(() -> {
            ReportFilters.ReportFiltersBuilder reportFiltersBuilder = new ReportFilters.ReportFiltersBuilder();
            allParams.forEach((k, v) -> this.reportFiltersMapper.map((String)k, (String)v, reportFiltersBuilder));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("reports", this.reportService.findReports(reportFiltersBuilder.build(), page * 45, 45));
            return GuiTemplate.template("gui/reports/find-reports.ftl", params);
        });
    }

    @GuiAction(value="manage-reports/view/open")
    public AsyncGui<GuiTemplate> openReportsGui(@GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("reports", this.reportService.getUnresolvedReports(45 * page, 45));
            return GuiTemplate.template("gui/reports/open-reports.ftl", params);
        });
    }

    @GuiAction(value="manage-reports/view/detail")
    public AsyncGui<GuiTemplate> goToManageReportView(Player player, @GuiParam(value="reportId") int reportId) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("player", player);
            params.put("report", this.reportService.getReport(reportId));
            Optional<ChatChannel> channel = this.chatChannelService.findChannel(String.valueOf(reportId), ChatChannelType.REPORT);
            params.put("channelPresent", channel.isPresent());
            params.put("isMemberOfChannel", channel.isPresent() && channel.get().getMembers().contains(player.getUniqueId()));
            return GuiTemplate.template("gui/reports/report-detail.ftl", params);
        });
    }

    @GuiAction(value="manage-reports/view/assigned")
    public AsyncGui<GuiTemplate> allAssignedReportsGui(@GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("reports", this.reportService.getAllAssignedReports(45 * page, 45));
            return GuiTemplate.template("gui/reports/assigned-reports.ftl", params);
        });
    }

    @GuiAction(value="manage-reports/view/closed")
    public AsyncGui<GuiTemplate> closedReportsGui(@GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("reports", this.manageReportService.getClosedReports(45 * page, 45));
            return GuiTemplate.template("gui/reports/closed-reports.ftl", params);
        });
    }

    @GuiAction(value="manage-reports/view/my-assigned")
    public AsyncGui<GuiTemplate> myAssignedReportsGui(Player player, @GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("reports", this.reportService.getAssignedReports(player.getUniqueId(), 45 * page, 45));
            return GuiTemplate.template("gui/reports/my-assigned-reports.ftl", params);
        });
    }

    @GuiAction(value="my-reports/view")
    public AsyncGui<GuiTemplate> myReportsGui(Player player, @GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("reports", this.reportService.getMyReports(player.getUniqueId(), 45 * page, 45));
            return GuiTemplate.template("gui/reports/my-reports.ftl", params);
        });
    }

    @GuiAction(value="manage-reports/accept")
    public AsyncGui<GuiActionReturnType> acceptReport(Player player, @GuiParam(value="reportId") int reportId) {
        this.permissionHandler.validate((CommandSender)player, this.manageReportConfiguration.permissionAccept);
        return AsyncGui.async(() -> {
            SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(player.getUniqueId()).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            this.manageReportService.acceptReport(sppPlayer, reportId);
            return GuiActionReturnType.BACK;
        });
    }

    @GuiAction(value="manage-reports/delete")
    public void deleteReport(Player player, @GuiParam(value="reportId") int reportId) {
        this.permissionHandler.validate((CommandSender)player, this.manageReportConfiguration.permissionDelete);
        SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(player.getUniqueId()).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.manageReportService.deleteReport(sppPlayer, reportId));
    }

    @GuiAction(value="manage-reports/reopen")
    public void reopenReport(Player player, @GuiParam(value="reportId") int reportId) {
        this.permissionHandler.validate((CommandSender)player, this.manageReportConfiguration.permissionReopenOther);
        SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(player.getUniqueId()).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.manageReportService.reopenReport(sppPlayer, reportId));
    }

    @GuiAction(value="manage-reports/teleport")
    public void teleportToReport(Player player, @GuiParam(value="reportId") int reportId) {
        Report report = this.reportService.getReport(reportId);
        if (report.getLocation().isPresent()) {
            this.reportService.goToReportLocation(player, report.getId());
        } else {
            this.messages.send((CommandSender)player, "&cLocation not known for this report.", this.messages.prefixReports);
        }
    }

    @GuiAction(value="manage-reports/join-chatchannel")
    public AsyncGui<GuiActionReturnType> joinChatChannel(Player player, @GuiParam(value="reportId") int reportId) {
        return AsyncGui.async(() -> {
            SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(player.getUniqueId()).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            this.chatChannelService.joinChannel(sppPlayer, String.valueOf(reportId), ChatChannelType.REPORT);
            return GuiActionReturnType.BACK;
        });
    }

    @GuiAction(value="manage-reports/leave-chatchannel")
    public AsyncGui<GuiActionReturnType> leaveChatChannel(Player player, @GuiParam(value="reportId") int reportId) {
        return AsyncGui.async(() -> {
            SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(player.getUniqueId()).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            this.chatChannelService.leaveChannel(sppPlayer, String.valueOf(reportId), ChatChannelType.REPORT);
            return GuiActionReturnType.BACK;
        });
    }

    @GuiAction(value="manage-reports/open-chatchannel")
    public AsyncGui<GuiActionReturnType> openChatChannel(Player player, @GuiParam(value="reportId") int reportId) {
        return AsyncGui.async(() -> {
            SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(player.getUniqueId()).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            Report report = this.reportService.getReport(reportId);
            this.reportChatChannelService.openChannel(sppPlayer, report);
            return GuiActionReturnType.BACK;
        });
    }

    @GuiAction(value="manage-reports/close-chatchannel")
    public void closeChatChannel(Player player, @GuiParam(value="reportId") int reportId) {
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.chatChannelService.closeChannel(String.valueOf(reportId), ChatChannelType.REPORT));
    }

    @GuiAction(value="manage-reports/reject")
    public AsyncGui<GuiActionReturnType> rejectReport(Player player, @GuiParam(value="reportId") int reportId) {
        this.permissionHandler.validate((CommandSender)player, this.manageReportConfiguration.permissionReject);
        return AsyncGui.async(() -> {
            SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(player.getUniqueId()).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            if (this.reportConfiguration.isClosingReasonEnabled()) {
                this.showCloseReasonGui(player, message -> this.manageReportService.closeReport(sppPlayer, new CloseReportRequest(reportId, ReportStatus.REJECTED, (String)message)), this.rejectCancelled, this.rejectConfirmationLines);
                return null;
            }
            this.manageReportService.closeReport(sppPlayer, new CloseReportRequest(reportId, ReportStatus.REJECTED, null));
            return GuiActionReturnType.BACK;
        });
    }

    @GuiAction(value="manage-reports/accept-and-reject")
    public AsyncGui<GuiActionReturnType> acceptAndReject(Player player, @GuiParam(value="reportId") int reportId) {
        this.permissionHandler.validate((CommandSender)player, this.manageReportConfiguration.permissionAccept);
        this.permissionHandler.validate((CommandSender)player, this.manageReportConfiguration.permissionReject);
        return AsyncGui.async(() -> {
            SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(player.getUniqueId()).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            if (this.reportConfiguration.isClosingReasonEnabled()) {
                this.showCloseReasonGui(player, message -> this.manageReportService.acceptAndClose(sppPlayer, new CloseReportRequest(reportId, ReportStatus.REJECTED, (String)message)), this.rejectCancelled, this.rejectConfirmationLines);
                return null;
            }
            this.manageReportService.acceptAndClose(sppPlayer, new CloseReportRequest(reportId, ReportStatus.REJECTED, null));
            return GuiActionReturnType.BACK;
        });
    }

    @GuiAction(value="manage-reports/resolve")
    public AsyncGui<GuiActionReturnType> resolveReport(Player player, @GuiParam(value="reportId") int reportId) {
        this.permissionHandler.validate((CommandSender)player, this.manageReportConfiguration.permissionResolve);
        return AsyncGui.async(() -> {
            SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(player.getUniqueId()).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            if (this.reportConfiguration.isClosingReasonEnabled()) {
                this.showCloseReasonGui(player, message -> this.manageReportService.closeReport(sppPlayer, new CloseReportRequest(reportId, ReportStatus.RESOLVED, (String)message)), this.resolveCancelled, this.resolveConfirmationLines);
                return null;
            }
            this.manageReportService.closeReport(sppPlayer, new CloseReportRequest(reportId, ReportStatus.RESOLVED, null));
            return GuiActionReturnType.BACK;
        });
    }

    @GuiAction(value="manage-reports/accept-and-resolve")
    public AsyncGui<GuiActionReturnType> acceptAndResolve(Player player, @GuiParam(value="reportId") int reportId) {
        this.permissionHandler.validate((CommandSender)player, this.manageReportConfiguration.permissionAccept);
        this.permissionHandler.validate((CommandSender)player, this.manageReportConfiguration.permissionResolve);
        return AsyncGui.async(() -> {
            SppPlayer sppPlayer = this.playerManager.getOnOrOfflinePlayer(player.getUniqueId()).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            if (this.reportConfiguration.isClosingReasonEnabled()) {
                this.showCloseReasonGui(player, message -> this.manageReportService.acceptAndClose(sppPlayer, new CloseReportRequest(reportId, ReportStatus.RESOLVED, (String)message)), this.resolveCancelled, this.resolveConfirmationLines);
                return null;
            }
            this.manageReportService.acceptAndClose(sppPlayer, new CloseReportRequest(reportId, ReportStatus.RESOLVED, null));
            return GuiActionReturnType.BACK;
        });
    }

    private void showCloseReasonGui(Player player, Consumer<String> onClose, String rejectCancelled, String messageLines) {
        this.messages.send((CommandSender)player, messageLines, this.messages.prefixReports);
        PlayerSession playerSession = this.sessionManager.get(player);
        playerSession.setChatAction((player1, message) -> {
            if (message.equalsIgnoreCase(CANCEL)) {
                this.messages.send((CommandSender)player, rejectCancelled, this.messages.prefixReports);
                return;
            }
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> onClose.accept(message));
        });
    }
}

