/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.gui;

import java.util.HashMap;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.SppInteractorBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.reporting.ReportService;
import net.shortninja.staffplus.core.domain.staff.reporting.config.CulpritFilterPredicate;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ManageReportConfiguration;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportConfiguration;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class CreateReportsGuiController {
    private final PermissionHandler permissionHandler;
    private final ManageReportConfiguration manageReportConfiguration;
    private final ReportService reportService;
    private final BukkitUtils bukkitUtils;
    private final PlayerManager playerManager;
    private final ReportConfiguration reportConfiguration;

    public CreateReportsGuiController(PermissionHandler permissionHandler, ManageReportConfiguration manageReportConfiguration, ReportService reportService, BukkitUtils bukkitUtils, PlayerManager playerManager, ReportConfiguration reportConfiguration) {
        this.permissionHandler = permissionHandler;
        this.manageReportConfiguration = manageReportConfiguration;
        this.reportService = reportService;
        this.bukkitUtils = bukkitUtils;
        this.playerManager = playerManager;
        this.reportConfiguration = reportConfiguration;
    }

    @GuiAction(value="reports/view/type-select")
    public GuiTemplate showTypeSelect(@GuiParam(value="culprit") String culprit, @GuiParam(value="reason") String reason) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("types", this.reportConfiguration.getReportTypeConfigurations(new CulpritFilterPredicate(StringUtils.isNotEmpty(culprit))));
        params.put("skipReasonSelect", StringUtils.isNotEmpty(reason));
        return GuiTemplate.template("gui/reports/report-type-selection.ftl", params);
    }

    @GuiAction(value="reports/view/reason-select")
    public GuiTemplate showReasonSelect(@GuiParam(value="culprit") String culprit, @GuiParam(value="type") String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("reasons", this.reportConfiguration.getReportReasonConfigurations(new CulpritFilterPredicate(StringUtils.isNotEmpty(culprit))).stream().filter(r -> type == null || r.getReportType().isPresent() && r.getReportType().get().equals(type)).collect(Collectors.toList()));
        return GuiTemplate.template("gui/reports/report-reason-selection.ftl", params);
    }

    @GuiAction(value="reports/create")
    public void createReport(Player player, @GuiParam(value="culprit") String culprit, @GuiParam(value="reason") String reportReason, @GuiParam(value="type") String reportType) {
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            if (StringUtils.isNotEmpty(culprit)) {
                SppPlayer culpritPlayer = this.playerManager.getOnOrOfflinePlayer(culprit).orElseThrow(() -> new PlayerNotFoundException(culprit));
                this.reportService.sendReport(SppInteractorBuilder.fromSender((CommandSender)player), culpritPlayer, reportReason, reportType);
            } else {
                this.reportService.sendReport(SppInteractorBuilder.fromSender((CommandSender)player), reportReason, reportType);
            }
        });
    }
}

