/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.transformers.ToEnum;
import net.shortninja.staffplus.core.domain.actions.config.FiltersTransformer;
import org.bukkit.Material;

public class ReportReasonConfiguration {
    @ConfigProperty(value="reason")
    private String reason;
    @ConfigProperty(value="material")
    @ConfigTransformer(value={ToEnum.class})
    private Material material = Material.PAPER;
    @ConfigProperty(value="info")
    private String lore;
    @ConfigProperty(value="type")
    private String reportType;
    @ConfigProperty(value="filters")
    @ConfigTransformer(value={FiltersTransformer.class})
    private Map<String, String> filters = new HashMap<String, String>();

    public String getReason() {
        return this.reason;
    }

    public Optional<String> getReportType() {
        return Optional.ofNullable(this.reportType);
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getLore() {
        return this.lore;
    }

    public boolean filterMatches(Predicate<Map<String, String>>[] predicate) {
        return Arrays.stream(predicate).allMatch(p -> p.test(this.filters));
    }
}

