/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.reporting.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.SoundsConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigObjectList;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.common.Sounds;
import net.shortninja.staffplus.core.domain.actions.config.ConfiguredCommand;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportReasonConfiguration;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportStatusesConfigTransformer;
import net.shortninja.staffplus.core.domain.staff.reporting.config.ReportTypeConfiguration;
import net.shortninja.staffplusplus.reports.ReportStatus;

@IocBean
public class ReportConfiguration {
    @ConfigProperty(value="reports-module.enabled")
    private boolean enabled;
    @ConfigProperty(value="reports-module.cooldown")
    private int cooldown;
    @ConfigProperty(value="reports-module.show-reporter")
    private boolean showReporter;
    @ConfigProperty(value="reports-module.sound")
    @ConfigTransformer(value={SoundsConfigTransformer.class})
    private Sounds sound;
    @ConfigProperty(value="reports-module.closing-reason-enabled")
    private boolean closingReasonEnabled;
    @ConfigProperty(value="permissions:view-my-reports")
    private String myReportsPermission;
    @ConfigProperty(value="commands:my-reports")
    private List<String> myReportsCmd;
    @ConfigProperty(value="reports-module.reporter-notifications.notify-on-join")
    private boolean notifyReporterOnJoin;
    @ConfigProperty(value="reports-module.reporter-notifications.status-change-notifications")
    @ConfigTransformer(value={ReportStatusesConfigTransformer.class})
    private List<ReportStatus> reporterNotifyStatuses;
    @ConfigProperty(value="reports-module.report-types")
    @ConfigObjectList(value=ReportTypeConfiguration.class)
    private List<ReportTypeConfiguration> reportTypeConfigurations = new ArrayList<ReportTypeConfiguration>();
    @ConfigProperty(value="reports-module.reasons")
    @ConfigObjectList(value=ReportReasonConfiguration.class)
    private List<ReportReasonConfiguration> reportReasonConfigurations = new ArrayList<ReportReasonConfiguration>();
    @ConfigProperty(value="reports-module.fixed-reason")
    private boolean fixedReason;
    @ConfigProperty(value="reports-module.fixed-reason-culprit")
    private boolean fixedReasonCulprit;
    @ConfigProperty(value="reports-module.accept-commands")
    @ConfigObjectList(value=ConfiguredCommand.class)
    private List<ConfiguredCommand> acceptReportActions = new ArrayList<ConfiguredCommand>();
    @ConfigProperty(value="reports-module.reject-commands")
    @ConfigObjectList(value=ConfiguredCommand.class)
    private List<ConfiguredCommand> rejectReportActions = new ArrayList<ConfiguredCommand>();
    @ConfigProperty(value="reports-module.reopen-commands")
    @ConfigObjectList(value=ConfiguredCommand.class)
    private List<ConfiguredCommand> reopenReportActions = new ArrayList<ConfiguredCommand>();
    @ConfigProperty(value="reports-module.resolve-commands")
    @ConfigObjectList(value=ConfiguredCommand.class)
    private List<ConfiguredCommand> resolveReportActions = new ArrayList<ConfiguredCommand>();

    public boolean isFixedReason() {
        return this.fixedReason;
    }

    public boolean isFixedReasonCulprit() {
        return this.fixedReasonCulprit;
    }

    public boolean isClosingReasonEnabled() {
        return this.closingReasonEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean isShowReporter() {
        return this.showReporter;
    }

    public Optional<Sounds> getSound() {
        return Optional.ofNullable(this.sound);
    }

    public String getMyReportsPermission() {
        return this.myReportsPermission;
    }

    public String getMyReportsCmd() {
        return this.myReportsCmd.get(0);
    }

    public boolean isNotifyReporterOnJoin() {
        return this.notifyReporterOnJoin;
    }

    public List<ReportStatus> getReporterNotifyStatuses() {
        return this.reporterNotifyStatuses;
    }

    @SafeVarargs
    public final List<ReportTypeConfiguration> getReportTypeConfigurations(Predicate<Map<String, String>> ... filterPredicates) {
        return this.reportTypeConfigurations.stream().filter(c -> c.filterMatches(filterPredicates)).collect(Collectors.toList());
    }

    @SafeVarargs
    public final List<ReportReasonConfiguration> getReportReasonConfigurations(Predicate<Map<String, String>> ... filterPredicates) {
        return this.reportReasonConfigurations.stream().filter(c -> c.filterMatches(filterPredicates)).collect(Collectors.toList());
    }

    public List<ConfiguredCommand> getAcceptReportActions() {
        return this.acceptReportActions;
    }

    public List<ConfiguredCommand> getRejectReportActions() {
        return this.rejectReportActions;
    }

    public List<ConfiguredCommand> getReopenReportActions() {
        return this.reopenReportActions;
    }

    public List<ConfiguredCommand> getResolveReportActions() {
        return this.resolveReportActions;
    }
}

